/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.webconsole.internal.servlet;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import org.osgi.framework.BundleContext;

public class ConfigurationUtil {
    private ConfigurationUtil() {
    }

    public static final String getProperty(BundleContext context, String name, String def) {
        String value = context.getProperty(name);
        return value == null ? def : value;
    }

    public static final int getProperty(BundleContext context, String name, int def) {
        String value = context.getProperty(name);
        if (value != null) {
            try {
                return Integer.parseInt(value.toString());
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
        }
        return def;
    }

    public static final String getProperty(Map config, String name, String def) {
        Object value = config.get(name);
        if (value instanceof String) {
            return (String)value;
        }
        if (value == null) {
            return def;
        }
        return String.valueOf(value);
    }

    public static final int getProperty(Map config, String name, int def) {
        Object value = config.get(name);
        if (value instanceof Number) {
            return ((Number)value).intValue();
        }
        if (value != null) {
            try {
                return Integer.parseInt(value.toString());
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
        }
        return def;
    }

    public static final String[] getStringArrayProperty(Map config, String name) {
        String[] ret;
        block5: {
            String pv;
            Object value;
            block6: {
                block4: {
                    value = config.get(name);
                    if (value == null) {
                        return null;
                    }
                    ret = null;
                    if (!value.getClass().isArray()) break block4;
                    Object[] names = (Object[])value;
                    ret = new String[names.length];
                    for (int i = 0; i < names.length; ++i) {
                        ret[i] = String.valueOf(names[i]);
                    }
                    break block5;
                }
                if (!(value instanceof Collection)) break block6;
                Collection collection = (Collection)value;
                ret = new String[collection.size()];
                int i = 0;
                Iterator iter = collection.iterator();
                while (iter.hasNext()) {
                    ret[i] = String.valueOf(iter.next());
                    ++i;
                }
                break block5;
            }
            if (!(value instanceof String) || (pv = ((String)value).trim()).length() == 0) break block5;
            StringTokenizer tok = new StringTokenizer(pv, ",;");
            ret = new String[tok.countTokens()];
            int i = 0;
            while (tok.hasMoreTokens()) {
                ret[i] = tok.nextToken();
                ++i;
            }
        }
        return ret;
    }
}

