/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.test.api;

import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import javax.jcr.nodetype.NodeType;
import org.apache.jackrabbit.test.AbstractJCRTest;
import org.apache.jackrabbit.test.NotExecutableException;
import org.apache.jackrabbit.test.api.NodeMixinUtil;

public class NodeCanAddMixinTest
extends AbstractJCRTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testLocked() throws ConstraintViolationException, NotExecutableException, RepositoryException {
        Session session = this.testRootNode.getSession();
        if (!this.isSupported("option.locking.supported")) {
            throw new NotExecutableException("Locking is not supported.");
        }
        Node node = this.testRootNode.addNode(this.nodeName1, this.testNodeType);
        this.ensureMixinType(node, this.mixLockable);
        this.testRootNode.save();
        String mixinName = NodeMixinUtil.getAddableMixinName(session, node);
        if (mixinName == null) {
            throw new NotExecutableException("No testable mixin node type found");
        }
        String pathRelToRoot = node.getPath().substring(1);
        Session session2 = this.getHelper().getSuperuserSession();
        try {
            Node node2 = session2.getRootNode().getNode(pathRelToRoot);
            node2.lock(true, true);
            node.refresh(false);
            NodeCanAddMixinTest.assertFalse((String)"Node.canAddMixin(String mixinName) must return false if the node is locked.", (boolean)node.canAddMixin(mixinName));
            node2.unlock();
        }
        finally {
            session2.logout();
        }
    }

    public void testCheckedIn() throws ConstraintViolationException, NotExecutableException, RepositoryException {
        Session session = this.testRootNode.getSession();
        if (!this.isSupported("option.versioning.supported")) {
            throw new NotExecutableException("Versioning is not supported.");
        }
        Node node = this.testRootNode.addNode(this.nodeName1, this.testNodeType);
        this.ensureMixinType(node, this.mixVersionable);
        this.testRootNode.save();
        String mixinName = NodeMixinUtil.getAddableMixinName(session, node);
        if (mixinName == null) {
            throw new NotExecutableException("No testable mixin node type found");
        }
        node.checkin();
        NodeCanAddMixinTest.assertFalse((String)"Node.canAddMixin(String mixinName) must return false if the node is checked-in.", (boolean)node.canAddMixin(mixinName));
    }

    public void testNonExisting() throws RepositoryException {
        Session session = this.testRootNode.getSession();
        String nonExistingMixinName = NodeMixinUtil.getNonExistingMixinName(session);
        Node node = this.testRootNode.addNode(this.nodeName1, this.testNodeType);
        try {
            node.canAddMixin(nonExistingMixinName);
            NodeCanAddMixinTest.fail((String)"Node.canAddMixin(String mixinName) must throw a NoSuchNodeTypeException if mixinName is an unknown mixin type");
        }
        catch (NoSuchNodeTypeException e) {
            // empty catch block
        }
    }

    public void testAddMixinTwice() throws RepositoryException, NotExecutableException {
        Node node;
        Session session = this.testRootNode.getSession();
        String mixinName = NodeMixinUtil.getAddableMixinName(session, node = this.testRootNode.addNode(this.nodeName1, this.testNodeType));
        if (mixinName == null) {
            throw new NotExecutableException("No testable mixin node type found");
        }
        NodeCanAddMixinTest.assertTrue((boolean)node.canAddMixin(mixinName));
        node.addMixin(mixinName);
        NodeCanAddMixinTest.assertTrue((boolean)node.canAddMixin(mixinName));
        session.save();
        NodeCanAddMixinTest.assertTrue((boolean)node.canAddMixin(mixinName));
    }

    public void testAddInheritedMixin() throws RepositoryException {
        Session session = this.testRootNode.getSession();
        Node node = this.testRootNode.addNode(this.nodeName1, this.testNodeType);
        session.save();
        NodeType nt = node.getPrimaryNodeType();
        NodeType[] superTypes = nt.getSupertypes();
        for (int i = 0; i < superTypes.length; ++i) {
            if (!superTypes[i].isMixin()) continue;
            String mixinName = superTypes[i].getName();
            NodeCanAddMixinTest.assertTrue((boolean)node.canAddMixin(mixinName));
        }
    }
}

