/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.test.api;

import java.util.NoSuchElementException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.nodetype.NodeType;
import org.apache.jackrabbit.test.AbstractJCRTest;
import org.apache.jackrabbit.test.NotExecutableException;

public class NodeDiscoveringNodeTypesTest
extends AbstractJCRTest {
    private Session session;
    private Node childNode;

    protected void setUp() throws Exception {
        this.isReadOnly = true;
        super.setUp();
        this.session = this.getHelper().getReadOnlySession();
        this.testRootNode = this.session.getRootNode().getNode(this.testPath);
        NodeIterator nodes = this.testRootNode.getNodes();
        try {
            this.childNode = nodes.nextNode();
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    protected void tearDown() throws Exception {
        if (this.session != null) {
            this.session.logout();
            this.session = null;
        }
        this.childNode = null;
        super.tearDown();
    }

    public void testGetPrimaryNodeType() throws NotExecutableException, RepositoryException {
        if (this.childNode == null) {
            throw new NotExecutableException("Workspace does not have sufficient content for this test. Root node must have at least one child node.");
        }
        NodeType type = this.childNode.getPrimaryNodeType();
        String name = this.childNode.getProperty(this.jcrPrimaryType).getString();
        NodeDiscoveringNodeTypesTest.assertEquals((String)"getPrimaryNodeType() must return the node type stored as property \"jcr:primaryType\"", (String)name, (String)type.getName());
        NodeDiscoveringNodeTypesTest.assertFalse((String)"getPrimaryNodeType() must return a primary node type", (boolean)type.isMixin());
    }

    public void testGetMixinNodeTypes() throws NotExecutableException, RepositoryException {
        int i;
        if (this.childNode == null) {
            throw new NotExecutableException("Workspace does not have sufficient content for this test. Root node must have at least one child node.");
        }
        Node node = this.locateNodeWithMixinNodeTypes(this.testRootNode);
        if (node == null) {
            throw new NotExecutableException("Workspace does not contain a node with mixin node types defined");
        }
        Value[] names = node.getProperty(this.jcrMixinTypes).getValues();
        NodeType[] types = node.getMixinNodeTypes();
        NodeDiscoveringNodeTypesTest.assertEquals((String)"getMixinNodeTypes() does not return the same number of node types as getProperty(\"jcr:mixinTypes\").getValues()", (int)types.length, (int)names.length);
        StringBuffer namesString = new StringBuffer();
        for (i = 0; i < names.length; ++i) {
            namesString.append("|" + names[i].getString() + "|");
        }
        for (i = 0; i < types.length; ++i) {
            String pattern = "|" + types[i].getName() + "|";
            NodeDiscoveringNodeTypesTest.assertTrue((String)"getMixinNodeTypes() does not return the same nodetypes as getProperty(\"jcr:mixinTypes\").getValues()", (namesString.indexOf(pattern) != -1 ? 1 : 0) != 0);
            NodeDiscoveringNodeTypesTest.assertTrue((String)"All nodes returned by getMixinNodeTypes() must bemixin", (boolean)types[i].isMixin());
        }
    }

    public void testIsNodeType() throws NotExecutableException, RepositoryException {
        String nodeTypeName = this.testRootNode.getPrimaryNodeType().getName();
        NodeDiscoveringNodeTypesTest.assertTrue((String)"isNodeType(String nodeTypeName) must return true if nodeTypeName is the name of the primary node type", (boolean)this.testRootNode.isNodeType(nodeTypeName));
        Node nodeWithMixin = this.locateNodeWithMixinNodeTypes(this.testRootNode);
        if (nodeWithMixin != null) {
            NodeType[] types = nodeWithMixin.getMixinNodeTypes();
            nodeTypeName = types[0].getName();
            NodeDiscoveringNodeTypesTest.assertTrue((String)"isNodeType(String nodeTypeName) must return true if nodeTypeName is the name of one of the mixin node types", (boolean)nodeWithMixin.isNodeType(nodeTypeName));
        }
        NodeDiscoveringNodeTypesTest.assertTrue((String)"isNodeType(String nodeTypeName) must return true if nodeTypeName is the name of a node type of a supertype", (boolean)this.testRootNode.isNodeType(this.ntBase));
    }

    private Node locateNodeWithMixinNodeTypes(Node node) throws RepositoryException {
        if (node.getMixinNodeTypes().length != 0) {
            return node;
        }
        NodeIterator nodes = node.getNodes();
        while (nodes.hasNext()) {
            Node returnedNode = this.locateNodeWithMixinNodeTypes(nodes.nextNode());
            if (returnedNode == null) continue;
            return returnedNode;
        }
        return null;
    }
}

