/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.test.api;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import org.apache.jackrabbit.test.AbstractJCRTest;

public class RepositoryDescriptorTest
extends AbstractJCRTest {
    private static final Set requiredDescriptorKeys = new HashSet();
    private Session session;

    protected void setUp() throws Exception {
        this.isReadOnly = true;
        super.setUp();
        this.session = this.getHelper().getReadOnlySession();
    }

    protected void tearDown() throws Exception {
        if (this.session != null) {
            this.session.logout();
            this.session = null;
        }
        super.tearDown();
    }

    public void testRequiredDescriptors() {
        Repository rep = this.session.getRepository();
        Iterator it = requiredDescriptorKeys.iterator();
        while (it.hasNext()) {
            String descName = (String)it.next();
            RepositoryDescriptorTest.assertTrue((String)(descName + " is a standard descriptor"), (boolean)rep.isStandardDescriptor(descName));
            if (rep.isSingleValueDescriptor(descName)) {
                Value val = rep.getDescriptorValue(descName);
                RepositoryDescriptorTest.assertNotNull((String)("Required descriptor is missing: " + descName), (Object)val);
                continue;
            }
            Value[] vals = rep.getDescriptorValues(descName);
            RepositoryDescriptorTest.assertNotNull((String)("Required descriptor is missing: " + descName), (Object)vals);
        }
    }

    public void testGetDescriptorKeys() {
        List<String> keys = Arrays.asList(this.session.getRepository().getDescriptorKeys());
        Iterator it = requiredDescriptorKeys.iterator();
        while (it.hasNext()) {
            String key = (String)it.next();
            RepositoryDescriptorTest.assertTrue((String)("Required descriptor is missing: " + key), (boolean)keys.contains(key));
        }
    }

    public void testGetDescriptorValues() {
        Repository rep = this.session.getRepository();
        String descName = "option.node.type.management.supported";
        RepositoryDescriptorTest.assertTrue((boolean)rep.isSingleValueDescriptor(descName));
        Value[] vals = rep.getDescriptorValues(descName);
        RepositoryDescriptorTest.assertNotNull((String)("Required descriptor is missing: " + descName), (Object)vals);
        RepositoryDescriptorTest.assertEquals((int)1, (int)vals.length);
        RepositoryDescriptorTest.assertEquals((int)6, (int)vals[0].getType());
        try {
            RepositoryDescriptorTest.assertEquals((String)vals[0].getString(), (String)rep.getDescriptor(descName));
        }
        catch (RepositoryException e) {
            RepositoryDescriptorTest.fail((String)e.getMessage());
        }
        descName = "query.languages";
        RepositoryDescriptorTest.assertFalse((boolean)rep.isSingleValueDescriptor(descName));
        Value val = rep.getDescriptorValue(descName);
        RepositoryDescriptorTest.assertNull((String)(descName + " is a multi-value descriptor, getDescriptorValue() should return null"), (Object)val);
    }

    static {
        requiredDescriptorKeys.add("identifier.stability");
        requiredDescriptorKeys.add("level.1.supported");
        requiredDescriptorKeys.add("level.2.supported");
        requiredDescriptorKeys.add("option.node.type.management.supported");
        requiredDescriptorKeys.add("node.type.management.autocreated.definitions.supported");
        requiredDescriptorKeys.add("node.type.management.inheritance");
        requiredDescriptorKeys.add("node.type.management.multiple.binary.properties.supported");
        requiredDescriptorKeys.add("node.type.management.multivalued.properties.supported");
        requiredDescriptorKeys.add("node.type.management.orderable.child.nodes.supported");
        requiredDescriptorKeys.add("node.type.management.overrides.supported");
        requiredDescriptorKeys.add("node.type.management.primary.item.name.supported");
        requiredDescriptorKeys.add("node.type.management.property.types");
        requiredDescriptorKeys.add("node.type.management.residual.definitions.supported");
        requiredDescriptorKeys.add("node.type.management.same.name.siblings.supported");
        requiredDescriptorKeys.add("node.type.management.value.constraints.supported");
        requiredDescriptorKeys.add("node.type.management.update.in.use.suported");
        requiredDescriptorKeys.add("option.access.control.supported");
        requiredDescriptorKeys.add("option.journaled.observation.supported");
        requiredDescriptorKeys.add("option.lifecycle.supported");
        requiredDescriptorKeys.add("option.locking.supported");
        requiredDescriptorKeys.add("option.observation.supported");
        requiredDescriptorKeys.add("option.node.and.property.with.same.name.supported");
        requiredDescriptorKeys.add("option.query.sql.supported");
        requiredDescriptorKeys.add("option.retention.supported");
        requiredDescriptorKeys.add("option.shareable.nodes.supported");
        requiredDescriptorKeys.add("option.simple.versioning.supported");
        requiredDescriptorKeys.add("option.transactions.supported");
        requiredDescriptorKeys.add("option.unfiled.content.supported");
        requiredDescriptorKeys.add("option.update.mixin.node.types.supported");
        requiredDescriptorKeys.add("option.update.primary.node.type.supported");
        requiredDescriptorKeys.add("option.versioning.supported");
        requiredDescriptorKeys.add("option.workspace.management.supported");
        requiredDescriptorKeys.add("option.xml.export.supported");
        requiredDescriptorKeys.add("option.xml.import.supported");
        requiredDescriptorKeys.add("option.activities.supported");
        requiredDescriptorKeys.add("option.baselines.supported");
        requiredDescriptorKeys.add("query.full.text.search.supported");
        requiredDescriptorKeys.add("query.joins");
        requiredDescriptorKeys.add("query.languages");
        requiredDescriptorKeys.add("query.stored.queries.supported");
        requiredDescriptorKeys.add("query.xpath.doc.order");
        requiredDescriptorKeys.add("query.xpath.pos.index");
        requiredDescriptorKeys.add("jcr.repository.name");
        requiredDescriptorKeys.add("jcr.repository.vendor");
        requiredDescriptorKeys.add("jcr.repository.vendor.url");
        requiredDescriptorKeys.add("jcr.specification.name");
        requiredDescriptorKeys.add("jcr.specification.version");
        requiredDescriptorKeys.add("write.supported");
    }
}

