/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.test.api;

import javax.jcr.Credentials;
import javax.jcr.NoSuchWorkspaceException;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.jackrabbit.test.AbstractJCRTest;

public class RepositoryLoginTest
extends AbstractJCRTest {
    private Credentials credentials;
    private String workspaceName;
    private Repository repository;

    protected void setUp() throws Exception {
        this.isReadOnly = true;
        super.setUp();
        this.credentials = this.getHelper().getReadOnlyCredentials();
        this.workspaceName = this.superuser.getWorkspace().getName();
        this.repository = this.getHelper().getRepository();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testNoSuchWorkspaceException() throws RepositoryException {
        String name;
        Session session = this.getHelper().getReadOnlySession();
        try {
            name = this.getNonExistingWorkspaceName(session);
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            session.logout();
            session = null;
            throw throwable;
        }
        session.logout();
        session = null;
        try {
            try {
                session = this.getHelper().getRepository().login(this.credentials, name);
                RepositoryLoginTest.fail((String)"login with a not available workspace name must throw a NoSuchWorkspaceException");
            }
            catch (NoSuchWorkspaceException noSuchWorkspaceException) {
                Object var6_8 = null;
                if (session == null) return;
                session.logout();
                return;
            }
            Object var6_7 = null;
            if (session == null) return;
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            if (session == null) throw throwable;
            session.logout();
            throw throwable;
        }
        session.logout();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSignatureCredentialsAndWorkspaceName() throws RepositoryException {
        Session s = this.repository.login(this.credentials, this.workspaceName);
        try {
            RepositoryLoginTest.assertNotNull((String)"Repository.login(Credentials credentials, String workspaceName) must not return null", (Object)s);
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            s.logout();
            throw throwable;
        }
        s.logout();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSignatureCredentials() throws RepositoryException {
        Session s = this.repository.login(this.credentials);
        try {
            RepositoryLoginTest.assertNotNull((String)"Repository.login(Credentials credentials) must not return null", (Object)s);
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            s.logout();
            throw throwable;
        }
        s.logout();
    }
}

