/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.test.api;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import javax.jcr.Item;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.Workspace;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.query.QueryResult;
import javax.jcr.version.Version;
import org.apache.jackrabbit.test.AbstractJCRTest;
import org.apache.jackrabbit.test.NotExecutableException;

public class ShareableNodeTest
extends AbstractJCRTest {
    private String mixShareable;

    protected void setUp() throws Exception {
        super.setUp();
        try {
            this.checkSupportedOption("option.shareable.nodes.supported");
            this.ensureKnowsNodeType(this.superuser, this.mixShareable);
        }
        catch (NotExecutableException e) {
            this.cleanUp();
            throw e;
        }
        this.mixShareable = this.superuser.getNamespacePrefix("http://www.jcp.org/jcr/mix/1.0") + ":shareable";
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testGetIndex() throws Exception {
        Node a1 = this.testRootNode.addNode("a1");
        Node a2 = this.testRootNode.addNode("a2");
        Node b1 = a1.addNode("b1");
        a2.addNode("b");
        this.testRootNode.save();
        this.ensureMixinType(b1, this.mixShareable);
        b1.save();
        Workspace workspace = b1.getSession().getWorkspace();
        workspace.clone(workspace.getName(), b1.getPath(), a2.getPath() + "/b", false);
        Node[] shared = ShareableNodeTest.getSharedSet(b1);
        ShareableNodeTest.assertEquals((int)2, (int)shared.length);
        b1 = shared[0];
        Node b2 = shared[1];
        ShareableNodeTest.assertEquals((int)1, (int)b1.getIndex());
        ShareableNodeTest.assertEquals((int)2, (int)b2.getIndex());
    }

    public void testGetName() throws Exception {
        Node a1 = this.testRootNode.addNode("a1");
        Node a2 = this.testRootNode.addNode("a2");
        Node b1 = a1.addNode("b1");
        this.testRootNode.save();
        this.ensureMixinType(b1, this.mixShareable);
        b1.save();
        Workspace workspace = b1.getSession().getWorkspace();
        workspace.clone(workspace.getName(), b1.getPath(), a2.getPath() + "/b2", false);
        Node[] shared = ShareableNodeTest.getSharedSet(b1);
        ShareableNodeTest.assertEquals((int)2, (int)shared.length);
        b1 = shared[0];
        Node b2 = shared[1];
        ShareableNodeTest.assertEquals((String)"b1", (String)b1.getName());
        ShareableNodeTest.assertEquals((String)"b2", (String)b2.getName());
    }

    public void testGetPath() throws Exception {
        Node a1 = this.testRootNode.addNode("a1");
        Node a2 = this.testRootNode.addNode("a2");
        Node b1 = a1.addNode("b1");
        this.testRootNode.save();
        this.ensureMixinType(b1, this.mixShareable);
        b1.save();
        Workspace workspace = b1.getSession().getWorkspace();
        workspace.clone(workspace.getName(), b1.getPath(), a2.getPath() + "/b2", false);
        Node[] shared = ShareableNodeTest.getSharedSet(b1);
        ShareableNodeTest.assertEquals((int)2, (int)shared.length);
        b1 = shared[0];
        Node b2 = shared[1];
        ShareableNodeTest.assertEquals((String)"/testroot/a1/b1", (String)b1.getPath());
        ShareableNodeTest.assertEquals((String)"/testroot/a2/b2", (String)b2.getPath());
    }

    public void testGetNode() throws Exception {
        Node a1 = this.testRootNode.addNode("a1");
        Node a2 = this.testRootNode.addNode("a2");
        Node b1 = a1.addNode("b1");
        this.testRootNode.save();
        this.ensureMixinType(b1, this.mixShareable);
        b1.save();
        Workspace workspace = b1.getSession().getWorkspace();
        workspace.clone(workspace.getName(), b1.getPath(), a2.getPath() + "/b2", false);
        b1 = a1.getNode("b1");
        ShareableNodeTest.assertEquals((String)"b1", (String)b1.getName());
        Node b2 = a2.getNode("b2");
        ShareableNodeTest.assertEquals((String)"b2", (String)b2.getName());
    }

    public void testGetNodes() throws Exception {
        Node a1 = this.testRootNode.addNode("a1");
        Node a2 = this.testRootNode.addNode("a2");
        Node b1 = a1.addNode("b1");
        this.testRootNode.save();
        this.ensureMixinType(b1, this.mixShareable);
        b1.save();
        Workspace workspace = b1.getSession().getWorkspace();
        workspace.clone(workspace.getName(), b1.getPath(), a2.getPath() + "/b2", false);
        Node[] children = ShareableNodeTest.toArray(a1.getNodes());
        ShareableNodeTest.assertEquals((int)1, (int)children.length);
        ShareableNodeTest.assertEquals((String)"b1", (String)children[0].getName());
        children = ShareableNodeTest.toArray(a2.getNodes());
        ShareableNodeTest.assertEquals((int)1, (int)children.length);
        ShareableNodeTest.assertEquals((String)"b2", (String)children[0].getName());
    }

    public void testGetNodesByPattern() throws Exception {
        Node a1 = this.testRootNode.addNode("a1");
        Node a2 = this.testRootNode.addNode("a2");
        Node b1 = a1.addNode("b1");
        this.testRootNode.save();
        this.ensureMixinType(b1, this.mixShareable);
        b1.save();
        Workspace workspace = b1.getSession().getWorkspace();
        workspace.clone(workspace.getName(), b1.getPath(), a2.getPath() + "/b2", false);
        Node[] children = ShareableNodeTest.toArray(a1.getNodes("*"));
        ShareableNodeTest.assertEquals((int)1, (int)children.length);
        ShareableNodeTest.assertEquals((String)"b1", (String)children[0].getName());
        children = ShareableNodeTest.toArray(a2.getNodes("*"));
        ShareableNodeTest.assertEquals((int)1, (int)children.length);
        ShareableNodeTest.assertEquals((String)"b2", (String)children[0].getName());
    }

    public void testGetSharedSet() throws Exception {
        Node a1 = this.testRootNode.addNode("a1");
        Node a2 = this.testRootNode.addNode("a2");
        Node b1 = a1.addNode("b1");
        this.testRootNode.save();
        this.ensureMixinType(b1, this.mixShareable);
        b1.save();
        Workspace workspace = b1.getSession().getWorkspace();
        workspace.clone(workspace.getName(), b1.getPath(), a2.getPath() + "/b2", false);
        Node[] shared = ShareableNodeTest.getSharedSet(b1);
        ShareableNodeTest.assertEquals((int)2, (int)shared.length);
    }

    public void testAddMixin() throws Exception {
        Node a = this.testRootNode.addNode("a");
        Node b = a.addNode("b");
        this.testRootNode.save();
        this.ensureMixinType(b, this.mixShareable);
        b.save();
    }

    public void testRestore() throws Exception {
        Node a1 = this.testRootNode.addNode("a1");
        Node a2 = this.testRootNode.addNode("a2");
        Node b1 = a1.addNode("b1");
        this.testRootNode.save();
        this.ensureMixinType(b1, this.mixShareable);
        b1.save();
        Workspace workspace = b1.getSession().getWorkspace();
        workspace.clone(workspace.getName(), b1.getPath(), a2.getPath() + "/b2", false);
        this.ensureMixinType(a2, this.mixVersionable);
        a2.save();
        Version v = a2.checkin();
        a2.checkout();
        a2.getNode("b2").remove();
        a2.save();
        Node[] shared = ShareableNodeTest.getSharedSet(b1);
        ShareableNodeTest.assertEquals((int)1, (int)shared.length);
        a2.restore(v, false);
        shared = ShareableNodeTest.getSharedSet(b1);
        ShareableNodeTest.assertEquals((int)2, (int)shared.length);
    }

    public void testRemoveShare() throws Exception {
        Node a1 = this.testRootNode.addNode("a1");
        Node a2 = this.testRootNode.addNode("a2");
        Node b1 = a1.addNode("b1");
        this.testRootNode.save();
        this.ensureMixinType(b1, this.mixShareable);
        b1.save();
        Workspace workspace = b1.getSession().getWorkspace();
        workspace.clone(workspace.getName(), b1.getPath(), a2.getPath() + "/b2", false);
        Node[] shared = ShareableNodeTest.getSharedSet(b1);
        ShareableNodeTest.assertEquals((int)2, (int)shared.length);
        b1 = shared[0];
        Node b2 = shared[1];
        b1.removeShare();
        a1.save();
        shared = ShareableNodeTest.getSharedSet(b2);
        ShareableNodeTest.assertEquals((int)1, (int)shared.length);
        ShareableNodeTest.assertTrue((boolean)shared[0].isSame((Item)b2));
    }

    public void testRemoveSharedSet() throws Exception {
        Node a1 = this.testRootNode.addNode("a1");
        Node a2 = this.testRootNode.addNode("a2");
        Node b1 = a1.addNode("b1");
        this.testRootNode.save();
        this.ensureMixinType(b1, this.mixShareable);
        b1.save();
        Workspace workspace = b1.getSession().getWorkspace();
        workspace.clone(workspace.getName(), b1.getPath(), a2.getPath() + "/b2", false);
        b1.removeSharedSet();
        this.testRootNode.save();
        ShareableNodeTest.assertFalse((boolean)a1.hasNodes());
        ShareableNodeTest.assertFalse((boolean)a2.hasNodes());
    }

    public void testRemoveSharedSetSaveOneParentOnly() throws Exception {
        Node a1 = this.testRootNode.addNode("a1");
        Node a2 = this.testRootNode.addNode("a2");
        Node b1 = a1.addNode("b1");
        this.testRootNode.save();
        this.ensureMixinType(b1, this.mixShareable);
        b1.save();
        Workspace workspace = b1.getSession().getWorkspace();
        workspace.clone(workspace.getName(), b1.getPath(), a2.getPath() + "/b2", false);
        b1.removeSharedSet();
        try {
            a1.save();
            ShareableNodeTest.fail((String)"Removing a shared set requires saving all parents.");
        }
        catch (ConstraintViolationException e) {
            // empty catch block
        }
    }

    public void testSameUUID() throws Exception {
        Node a1 = this.testRootNode.addNode("a1");
        Node a2 = this.testRootNode.addNode("a2");
        Node b1 = a1.addNode("b1");
        this.testRootNode.save();
        this.ensureMixinType(b1, this.mixShareable);
        b1.save();
        Workspace workspace = b1.getSession().getWorkspace();
        workspace.clone(workspace.getName(), b1.getPath(), a2.getPath() + "/b2", false);
        Node[] shared = ShareableNodeTest.getSharedSet(b1);
        ShareableNodeTest.assertEquals((int)2, (int)shared.length);
        b1 = shared[0];
        Node b2 = shared[1];
        ShareableNodeTest.assertTrue((boolean)b1.getUUID().equals(b2.getUUID()));
    }

    public void testAddChild() throws Exception {
        Node a1 = this.testRootNode.addNode("a1");
        Node a2 = this.testRootNode.addNode("a2");
        Node b1 = a1.addNode("b1");
        this.testRootNode.save();
        this.ensureMixinType(b1, this.mixShareable);
        b1.save();
        Workspace workspace = b1.getSession().getWorkspace();
        workspace.clone(workspace.getName(), b1.getPath(), a2.getPath() + "/b2", false);
        Node[] shared = ShareableNodeTest.getSharedSet(b1);
        ShareableNodeTest.assertEquals((int)2, (int)shared.length);
        b1 = shared[0];
        Node b2 = shared[1];
        b1.addNode("c");
        ShareableNodeTest.assertTrue((boolean)b2.isModified());
        ShareableNodeTest.assertTrue((boolean)b2.hasNode("c"));
        b1.save();
    }

    public void testCopy() throws Exception {
        Node s = this.testRootNode.addNode("s");
        Node a1 = s.addNode("a1");
        Node a2 = s.addNode("a2");
        Node b1 = a1.addNode("b1");
        this.testRootNode.save();
        this.ensureMixinType(b1, this.mixShareable);
        b1.save();
        Workspace workspace = b1.getSession().getWorkspace();
        workspace.clone(workspace.getName(), b1.getPath(), a2.getPath() + "/b2", false);
        workspace.copy(s.getPath(), this.testRootNode.getPath() + "/d");
        Node[] shared1 = ShareableNodeTest.getSharedSet(b1);
        ShareableNodeTest.assertEquals((int)2, (int)shared1.length);
        Node[] shared2 = ShareableNodeTest.getSharedSet(this.testRootNode.getNode("d/a1/b1"));
        ShareableNodeTest.assertEquals((int)2, (int)shared2.length);
        String srcUUID = shared1[0].getUUID();
        String destUUID = shared2[0].getUUID();
        ShareableNodeTest.assertFalse((String)"Source and destination of a copy must not have the same UUID", (boolean)srcUUID.equals(destUUID));
    }

    public void testDetectShareCycleOnClone() throws Exception {
        Node a1 = this.testRootNode.addNode("a1");
        Node b1 = a1.addNode("b1");
        this.testRootNode.save();
        this.ensureMixinType(b1, this.mixShareable);
        b1.save();
        Workspace workspace = b1.getSession().getWorkspace();
        try {
            workspace.clone(workspace.getName(), b1.getPath(), b1.getPath() + "/c", false);
            ShareableNodeTest.fail((String)"Share cycle not detected on clone.");
        }
        catch (RepositoryException e) {
            // empty catch block
        }
    }

    public void testDetectShareCycleOnMove() throws Exception {
        Node a1 = this.testRootNode.addNode("a1");
        Node a2 = this.testRootNode.addNode("a2");
        Node b1 = a1.addNode("b1");
        this.testRootNode.save();
        this.ensureMixinType(b1, this.mixShareable);
        b1.save();
        Workspace workspace = b1.getSession().getWorkspace();
        workspace.clone(workspace.getName(), b1.getPath(), a2.getPath() + "/b2", false);
        Node c = b1.addNode("c");
        b1.save();
        Node[] shared = ShareableNodeTest.getSharedSet(b1);
        ShareableNodeTest.assertEquals((int)2, (int)shared.length);
        try {
            workspace.move(this.testRootNode.getPath() + "/a2", c.getPath() + "/d");
            ShareableNodeTest.fail((String)"Share cycle not detected on move.");
        }
        catch (RepositoryException e) {
            // empty catch block
        }
    }

    public void testDetectShareCycleOnTransientMove() throws Exception {
        Node a1 = this.testRootNode.addNode("a1");
        Node a2 = this.testRootNode.addNode("a2");
        Node b1 = a1.addNode("b1");
        this.testRootNode.save();
        this.ensureMixinType(b1, this.mixShareable);
        b1.save();
        Session session = b1.getSession();
        Workspace workspace = session.getWorkspace();
        workspace.clone(workspace.getName(), b1.getPath(), a2.getPath() + "/b2", false);
        Node c = b1.addNode("c");
        b1.save();
        Node[] shared = ShareableNodeTest.getSharedSet(b1);
        ShareableNodeTest.assertEquals((int)2, (int)shared.length);
        try {
            session.move(this.testRootNode.getPath() + "/a2", c.getPath());
            ShareableNodeTest.fail((String)"Share cycle not detected on transient move.");
        }
        catch (RepositoryException e) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testImportExportNtShare() throws Exception {
        Node p = this.testRootNode.addNode("p");
        Node a1 = p.addNode("a1");
        Node a2 = p.addNode("a2");
        Node b1 = a1.addNode("b1");
        this.testRootNode.save();
        this.ensureMixinType(b1, this.mixShareable);
        b1.save();
        Session session = b1.getSession();
        Workspace workspace = session.getWorkspace();
        workspace.clone(workspace.getName(), b1.getPath(), a2.getPath() + "/b2", false);
        File tmpFile = File.createTempFile("test", null);
        tmpFile.deleteOnExit();
        FileOutputStream out = new FileOutputStream(tmpFile);
        try {
            session.exportSystemView(p.getPath(), (OutputStream)out, false, false);
            Object var10_9 = null;
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            ((OutputStream)out).close();
            throw throwable;
        }
        ((OutputStream)out).close();
        p.remove();
        this.testRootNode.save();
        FileInputStream in = new FileInputStream(tmpFile);
        try {
            workspace.importXML(this.testRootNode.getPath(), (InputStream)in, 3);
            Object var12_13 = null;
        }
        catch (Throwable throwable) {
            Object var12_14 = null;
            ((InputStream)in).close();
            throw throwable;
        }
        ((InputStream)in).close();
        Node[] shared = ShareableNodeTest.getSharedSet(this.testRootNode.getNode("p/a1/b1"));
        ShareableNodeTest.assertEquals((int)2, (int)shared.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testImportSystemViewCollision() throws Exception {
        Node a1 = this.testRootNode.addNode("a1");
        Node a2 = this.testRootNode.addNode("a2");
        Node a3 = this.testRootNode.addNode("a3");
        Node b1 = a1.addNode("b1");
        this.testRootNode.save();
        this.ensureMixinType(b1, this.mixShareable);
        b1.save();
        Session session = b1.getSession();
        Workspace workspace = session.getWorkspace();
        workspace.clone(workspace.getName(), b1.getPath(), a2.getPath() + "/b2", false);
        b1.addNode("c");
        b1.save();
        File tmpFile = File.createTempFile("test", null);
        tmpFile.deleteOnExit();
        FileOutputStream out = new FileOutputStream(tmpFile);
        try {
            session.exportSystemView(b1.getPath(), (OutputStream)out, false, false);
            Object var10_9 = null;
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            ((OutputStream)out).close();
            throw throwable;
        }
        ((OutputStream)out).close();
        FileInputStream in = new FileInputStream(tmpFile);
        try {
            workspace.importXML(a3.getPath(), (InputStream)in, 3);
            Object var12_13 = null;
        }
        catch (Throwable throwable) {
            Object var12_14 = null;
            ((InputStream)in).close();
            throw throwable;
        }
        ((InputStream)in).close();
        Node[] shared = ShareableNodeTest.getSharedSet(b1);
        ShareableNodeTest.assertEquals((int)3, (int)shared.length);
        Node[] children = ShareableNodeTest.toArray(b1.getNodes());
        ShareableNodeTest.assertEquals((int)1, (int)children.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testImportDocumentViewCollision() throws Exception {
        Node a1 = this.testRootNode.addNode("a1");
        Node a2 = this.testRootNode.addNode("a2");
        Node a3 = this.testRootNode.addNode("a3");
        Node b1 = a1.addNode("b1");
        this.testRootNode.save();
        this.ensureMixinType(b1, this.mixShareable);
        b1.save();
        Session session = b1.getSession();
        Workspace workspace = session.getWorkspace();
        workspace.clone(workspace.getName(), b1.getPath(), a2.getPath() + "/b2", false);
        b1.addNode("c");
        b1.save();
        File tmpFile = File.createTempFile("test", null);
        tmpFile.deleteOnExit();
        FileOutputStream out = new FileOutputStream(tmpFile);
        try {
            session.exportDocumentView(b1.getPath(), (OutputStream)out, false, false);
            Object var10_9 = null;
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            ((OutputStream)out).close();
            throw throwable;
        }
        ((OutputStream)out).close();
        FileInputStream in = new FileInputStream(tmpFile);
        try {
            workspace.importXML(a3.getPath(), (InputStream)in, 3);
            Object var12_13 = null;
        }
        catch (Throwable throwable) {
            Object var12_14 = null;
            ((InputStream)in).close();
            throw throwable;
        }
        ((InputStream)in).close();
        Node[] shared = ShareableNodeTest.getSharedSet(b1);
        ShareableNodeTest.assertEquals((int)3, (int)shared.length);
        Node[] children = ShareableNodeTest.toArray(b1.getNodes());
        ShareableNodeTest.assertEquals((int)1, (int)children.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSessionImportSystemViewCollision() throws Exception {
        Node a1 = this.testRootNode.addNode("a1");
        Node a2 = this.testRootNode.addNode("a2");
        Node a3 = this.testRootNode.addNode("a3");
        Node b1 = a1.addNode("b1");
        this.testRootNode.save();
        this.ensureMixinType(b1, this.mixShareable);
        b1.save();
        Session session = b1.getSession();
        Workspace workspace = session.getWorkspace();
        workspace.clone(workspace.getName(), b1.getPath(), a2.getPath() + "/b2", false);
        b1.addNode("c");
        b1.save();
        File tmpFile = File.createTempFile("test", null);
        tmpFile.deleteOnExit();
        FileOutputStream out = new FileOutputStream(tmpFile);
        try {
            session.exportSystemView(b1.getPath(), (OutputStream)out, false, false);
            Object var10_9 = null;
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            ((OutputStream)out).close();
            throw throwable;
        }
        ((OutputStream)out).close();
        FileInputStream in = new FileInputStream(tmpFile);
        try {
            session.importXML(a3.getPath(), (InputStream)in, 3);
            session.save();
            Object var12_13 = null;
        }
        catch (Throwable throwable) {
            Object var12_14 = null;
            ((InputStream)in).close();
            throw throwable;
        }
        ((InputStream)in).close();
        Node[] shared = ShareableNodeTest.getSharedSet(b1);
        ShareableNodeTest.assertEquals((int)3, (int)shared.length);
        Node[] children = ShareableNodeTest.toArray(b1.getNodes());
        ShareableNodeTest.assertEquals((int)1, (int)children.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSessionImportDocumentViewCollision() throws Exception {
        Node a1 = this.testRootNode.addNode("a1");
        Node a2 = this.testRootNode.addNode("a2");
        Node a3 = this.testRootNode.addNode("a3");
        Node b1 = a1.addNode("b1");
        this.testRootNode.save();
        this.ensureMixinType(b1, this.mixShareable);
        b1.save();
        Session session = b1.getSession();
        Workspace workspace = session.getWorkspace();
        workspace.clone(workspace.getName(), b1.getPath(), a2.getPath() + "/b2", false);
        b1.addNode("c");
        b1.save();
        File tmpFile = File.createTempFile("test", null);
        tmpFile.deleteOnExit();
        FileOutputStream out = new FileOutputStream(tmpFile);
        try {
            session.exportSystemView(b1.getPath(), (OutputStream)out, false, false);
            Object var10_9 = null;
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            ((OutputStream)out).close();
            throw throwable;
        }
        ((OutputStream)out).close();
        FileInputStream in = new FileInputStream(tmpFile);
        try {
            session.importXML(a3.getPath(), (InputStream)in, 3);
            session.save();
            Object var12_13 = null;
        }
        catch (Throwable throwable) {
            Object var12_14 = null;
            ((InputStream)in).close();
            throw throwable;
        }
        ((InputStream)in).close();
        Node[] shared = ShareableNodeTest.getSharedSet(b1);
        ShareableNodeTest.assertEquals((int)3, (int)shared.length);
        Node[] children = ShareableNodeTest.toArray(b1.getNodes());
        ShareableNodeTest.assertEquals((int)1, (int)children.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testLock() throws Exception {
        Node a1 = this.testRootNode.addNode("a1");
        this.ensureMixinType(a1, this.mixLockable);
        Node a2 = this.testRootNode.addNode("a2");
        Node b1 = a1.addNode("b1");
        this.testRootNode.save();
        this.ensureMixinType(b1, this.mixShareable);
        this.ensureMixinType(b1, this.mixLockable);
        b1.save();
        Node c = b1.addNode("c");
        b1.save();
        Workspace workspace = b1.getSession().getWorkspace();
        workspace.clone(workspace.getName(), b1.getPath(), a2.getPath() + "/b2", false);
        Node[] shared = ShareableNodeTest.getSharedSet(b1);
        ShareableNodeTest.assertEquals((int)2, (int)shared.length);
        b1 = shared[0];
        Node b2 = shared[1];
        b1.lock(false, true);
        try {
            ShareableNodeTest.assertTrue((boolean)b2.isLocked());
            Object var9_8 = null;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            b1.unlock();
            throw throwable;
        }
        b1.unlock();
        a1.lock(true, true);
        try {
            ShareableNodeTest.assertTrue((boolean)c.isLocked());
            Object var11_11 = null;
        }
        catch (Throwable throwable) {
            Object var11_12 = null;
            a1.unlock();
            throw throwable;
        }
        a1.unlock();
    }

    public void testRestoreRemoveExisting() throws Exception {
        Node a1 = this.testRootNode.addNode("a1");
        Node a2 = this.testRootNode.addNode("a2");
        Node b1 = a1.addNode("b1");
        this.testRootNode.save();
        this.ensureMixinType(b1, this.mixShareable);
        b1.save();
        Workspace workspace = b1.getSession().getWorkspace();
        workspace.clone(workspace.getName(), b1.getPath(), a2.getPath() + "/b2", false);
        b1.addNode("c");
        b1.save();
        this.ensureMixinType(a2, this.mixVersionable);
        a2.save();
        Version v = a2.checkin();
        a2.checkout();
        a2.getNode("b2").remove();
        a2.save();
        Node[] shared = ShareableNodeTest.getSharedSet(b1);
        ShareableNodeTest.assertEquals((int)1, (int)shared.length);
        a2.restore(v, true);
        shared = ShareableNodeTest.getSharedSet(a2.getNode("b2"));
        ShareableNodeTest.assertEquals((int)1, (int)shared.length);
        Node[] children = ShareableNodeTest.toArray(a2.getNode("b2").getNodes());
        ShareableNodeTest.assertEquals((int)1, (int)children.length);
    }

    public void testClone() throws Exception {
        Node a1 = this.testRootNode.addNode("a1");
        Node a2 = this.testRootNode.addNode("a2");
        Node b1 = a1.addNode("b1");
        this.testRootNode.save();
        Workspace workspace = b1.getSession().getWorkspace();
        try {
            workspace.clone(workspace.getName(), b1.getPath(), a2.getPath() + "/b2", false);
            ShareableNodeTest.fail((String)"Cloning a node into the same workspace should fail.");
        }
        catch (RepositoryException e) {
            // empty catch block
        }
        this.ensureMixinType(b1, this.mixShareable);
        b1.save();
        workspace.clone(workspace.getName(), b1.getPath(), a2.getPath() + "/b2", false);
    }

    public void testIsSame() throws Exception {
        Node a1 = this.testRootNode.addNode("a1");
        Node a2 = this.testRootNode.addNode("a2");
        Node b1 = a1.addNode("b1");
        this.testRootNode.save();
        this.ensureMixinType(b1, this.mixShareable);
        b1.save();
        Workspace workspace = b1.getSession().getWorkspace();
        workspace.clone(workspace.getName(), b1.getPath(), a2.getPath() + "/b2", false);
        Node[] shared = ShareableNodeTest.getSharedSet(b1);
        ShareableNodeTest.assertEquals((int)2, (int)shared.length);
        b1 = shared[0];
        Node b2 = shared[1];
        ShareableNodeTest.assertTrue((boolean)b1.isSame((Item)b2));
        ShareableNodeTest.assertTrue((boolean)b2.isSame((Item)b1));
    }

    public void testRemoveMixin() throws Exception {
        Node a = this.testRootNode.addNode("a");
        Node b = a.addNode("b");
        this.testRootNode.save();
        this.ensureMixinType(b, this.mixShareable);
        b.save();
        try {
            b.removeMixin(this.mixShareable);
            b.save();
            ShareableNodeTest.fail((String)"Removing mix:shareable should fail.");
        }
        catch (UnsupportedRepositoryOperationException unsupportedRepositoryOperationException) {
            // empty catch block
        }
    }

    public void testSearch() throws Exception {
        Node a1 = this.testRootNode.addNode("a1");
        Node a2 = this.testRootNode.addNode("a2");
        Node b1 = a1.addNode("b1");
        this.testRootNode.save();
        this.ensureMixinType(b1, this.mixShareable);
        b1.save();
        Workspace workspace = b1.getSession().getWorkspace();
        workspace.clone(workspace.getName(), b1.getPath(), a2.getPath() + "/b2", false);
        Node c = b1.addNode("c");
        this.ensureMixinType(c, this.mixReferenceable);
        b1.save();
        String sql = "SELECT * FROM nt:unstructured WHERE jcr:uuid = '" + c.getUUID() + "'";
        QueryResult res = workspace.getQueryManager().createQuery(sql, "sql").execute();
        ArrayList<Node> list = new ArrayList<Node>();
        NodeIterator iter = res.getNodes();
        while (iter.hasNext()) {
            list.add(iter.nextNode());
        }
        ShareableNodeTest.assertEquals((int)1, (int)list.size());
        ShareableNodeTest.assertTrue((boolean)((Node)list.get(0)).isSame((Item)c));
    }

    public void testCloneToSameParent() throws Exception {
        Node a = this.testRootNode.addNode("a");
        Node b1 = a.addNode("b1");
        this.testRootNode.save();
        this.ensureMixinType(b1, this.mixShareable);
        b1.save();
        Workspace workspace = b1.getSession().getWorkspace();
        try {
            workspace.clone(workspace.getName(), b1.getPath(), a.getPath() + "/b2", false);
            ShareableNodeTest.fail((String)"Cloning inside same parent should fail.");
        }
        catch (UnsupportedRepositoryOperationException e) {
            // empty catch block
        }
    }

    public void testMoveShareableNode() throws Exception {
        Node a1 = this.testRootNode.addNode("a1");
        Node a2 = this.testRootNode.addNode("a2");
        Node b = a1.addNode("b");
        this.testRootNode.save();
        this.ensureMixinType(b, this.mixShareable);
        b.save();
        Workspace workspace = b.getSession().getWorkspace();
        try {
            workspace.move(b.getPath(), a2.getPath() + "/b");
            ShareableNodeTest.fail((String)"Moving a mix:shareable should fail.");
        }
        catch (UnsupportedRepositoryOperationException e) {
            // empty catch block
        }
    }

    public void testTransientMoveShareableNode() throws Exception {
        Node a1 = this.testRootNode.addNode("a1");
        Node a2 = this.testRootNode.addNode("a2");
        Node b = a1.addNode("b");
        this.testRootNode.save();
        this.ensureMixinType(b, this.mixShareable);
        b.save();
        Session session = this.superuser;
        try {
            session.move(b.getPath(), a2.getPath() + "/b");
            session.save();
            ShareableNodeTest.fail((String)"Moving a mix:shareable should fail.");
        }
        catch (UnsupportedRepositoryOperationException e) {
            // empty catch block
        }
    }

    public void testRemoveDescendantAndSave() throws Exception {
        Node a1 = this.testRootNode.addNode("a1");
        Node a2 = this.testRootNode.addNode("a2");
        Node b1 = a1.addNode("b1");
        this.testRootNode.save();
        this.ensureMixinType(b1, this.mixShareable);
        b1.save();
        Session session = b1.getSession();
        Workspace workspace = b1.getSession().getWorkspace();
        workspace.clone(workspace.getName(), b1.getPath(), a2.getPath() + "/b2", false);
        Node c = b1.addNode("c");
        b1.save();
        c.remove();
        a2.save();
        ShareableNodeTest.assertFalse((String)"Saving share-ancestor should save share-descendants", (boolean)session.hasPendingChanges());
    }

    public void testRemoveDescendantAndRemoveShareAndSave() throws Exception {
        Node a1 = this.testRootNode.addNode("a1");
        Node a2 = this.testRootNode.addNode("a2");
        Node b1 = a1.addNode("b1");
        this.testRootNode.save();
        this.ensureMixinType(b1, this.mixShareable);
        b1.save();
        Session session = b1.getSession();
        Workspace workspace = b1.getSession().getWorkspace();
        workspace.clone(workspace.getName(), b1.getPath(), a2.getPath() + "/b2", false);
        Node c = b1.addNode("c");
        b1.save();
        c.remove();
        a2.getNode("b2").removeShare();
        a2.save();
        ShareableNodeTest.assertFalse((String)"Saving share-ancestor should save share-descendants", (boolean)session.hasPendingChanges());
    }

    public void testModifyDescendantAndSave() throws Exception {
        Node a1 = this.testRootNode.addNode("a1");
        Node a2 = this.testRootNode.addNode("a2");
        Node b1 = a1.addNode("b1");
        this.testRootNode.save();
        this.ensureMixinType(b1, this.mixShareable);
        b1.save();
        Workspace workspace = b1.getSession().getWorkspace();
        workspace.clone(workspace.getName(), b1.getPath(), a2.getPath() + "/b2", false);
        Node c = b1.addNode("c");
        b1.save();
        c.addNode("d");
        a2.save();
        ShareableNodeTest.assertFalse((String)"Saving share-ancestor should save share-descendants", (boolean)c.isModified());
    }

    public void testModifyDescendantAndRemoveShareAndSave() throws Exception {
        Node a1 = this.testRootNode.addNode("a1");
        Node a2 = this.testRootNode.addNode("a2");
        Node b1 = a1.addNode("b1");
        this.testRootNode.save();
        this.ensureMixinType(b1, this.mixShareable);
        b1.save();
        Workspace workspace = b1.getSession().getWorkspace();
        workspace.clone(workspace.getName(), b1.getPath(), a2.getPath() + "/b2", false);
        Node c = b1.addNode("c");
        b1.save();
        c.addNode("d");
        a2.getNode("b2").removeShare();
        a2.save();
        ShareableNodeTest.assertFalse((String)"Saving share-ancestor should save share-descendants", (boolean)c.isModified());
    }

    public void testCloneMultipleTimes() throws Exception {
        int i;
        int count = 10;
        Node[] parents = new Node[10];
        for (int i2 = 0; i2 < parents.length; ++i2) {
            parents[i2] = this.testRootNode.addNode("a" + (i2 + 1));
        }
        Node b = parents[0].addNode("b");
        this.testRootNode.save();
        this.ensureMixinType(b, this.mixShareable);
        b.save();
        Workspace workspace = b.getSession().getWorkspace();
        for (i = 1; i < parents.length; ++i) {
            workspace.clone(workspace.getName(), b.getPath(), parents[i].getPath() + "/b", false);
        }
        for (i = 0; i < parents.length; ++i) {
            parents[i].remove();
        }
        this.testRootNode.save();
    }

    public void testSharedNodePath() throws Exception {
        Node a1 = this.testRootNode.addNode("a1");
        Node a2 = a1.addNode("a2");
        Node b1 = a1.addNode("b1");
        this.ensureMixinType(b1, this.mixShareable);
        this.testRootNode.save();
        Session session = this.testRootNode.getSession();
        Workspace workspace = session.getWorkspace();
        String path = a2.getPath() + "/b2";
        workspace.clone(workspace.getName(), b1.getPath(), path, false);
        Item item = session.getItem(path);
        ShareableNodeTest.assertEquals((String)"unexpectedly got the path from another node from the same shared set", (String)path, (String)item.getPath());
    }

    private static Node[] getSharedSet(Node n) throws RepositoryException {
        return ShareableNodeTest.toArray(n.getSharedSet());
    }

    private static Node[] toArray(NodeIterator iter) {
        ArrayList<Node> list = new ArrayList<Node>();
        while (iter.hasNext()) {
            list.add(iter.nextNode());
        }
        Node[] result = new Node[list.size()];
        list.toArray(result);
        return result;
    }
}

