/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.test.api;

import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Workspace;
import org.apache.jackrabbit.test.AbstractJCRTest;

public class WorkspaceReadMethodsTest
extends AbstractJCRTest {
    protected void setUp() throws Exception {
        this.isReadOnly = true;
        super.setUp();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetSession() throws RepositoryException {
        Session session = this.getHelper().getReadOnlySession();
        try {
            Session otherSession = session.getWorkspace().getSession();
            WorkspaceReadMethodsTest.assertSame((String)"Workspace.getSession() returns not the same session object.", (Object)session, (Object)otherSession);
        }
        finally {
            session.logout();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetName() throws RepositoryException {
        Session session = this.getHelper().getReadOnlySession(this.workspaceName);
        try {
            String name = session.getWorkspace().getName();
            if (this.workspaceName != null) {
                WorkspaceReadMethodsTest.assertEquals((String)"Workspace.getName() returns wrong name.", (String)this.workspaceName, (String)name);
            }
        }
        finally {
            session.logout();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetQueryManager() throws RepositoryException {
        Workspace ws = this.getHelper().getReadOnlySession().getWorkspace();
        try {
            WorkspaceReadMethodsTest.assertNotNull((String)"Workspace does not return a QueryManager object.", (Object)ws.getQueryManager());
        }
        finally {
            ws.getSession().logout();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetAccessibleWorkspaceNames() throws RepositoryException {
        Session session = this.getHelper().getReadOnlySession();
        try {
            String[] wsNames = session.getWorkspace().getAccessibleWorkspaceNames();
            for (int i = 0; i < wsNames.length; ++i) {
                Session s = this.getHelper().getReadOnlySession(wsNames[i]);
                s.logout();
            }
        }
        finally {
            session.logout();
        }
    }
}

