/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.test.api.nodetype;

import java.text.ParseException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.PropertyDefinition;
import org.apache.jackrabbit.test.AbstractJCRTest;
import org.apache.jackrabbit.test.NotExecutableException;
import org.apache.jackrabbit.test.api.nodetype.NodeTypeUtil;

public class CanSetPropertyDateTest
extends AbstractJCRTest {
    private Session session;

    protected void setUp() throws Exception {
        this.isReadOnly = true;
        super.setUp();
        this.session = this.getHelper().getReadOnlySession();
    }

    protected void tearDown() throws Exception {
        if (this.session != null) {
            this.session.logout();
            this.session = null;
        }
        super.tearDown();
    }

    public void testConversions() throws NotExecutableException, RepositoryException {
        PropertyDefinition propDef = NodeTypeUtil.locatePropertyDef(this.session, 5, false, false, false, false);
        if (propDef == null) {
            throw new NotExecutableException("No date property def that meets the requirements of the test has been found");
        }
        NodeType nodeType = propDef.getDeclaringNodeType();
        Value anyStringValue = NodeTypeUtil.getValueOfType(this.session, 1);
        CanSetPropertyDateTest.assertFalse((String)"canSetProperty(String propertyName, Value value) must return false if the property is of type Date and value is a StringValue not in date format", (boolean)nodeType.canSetProperty(propDef.getName(), anyStringValue));
        Value dateStringValue = this.superuser.getValueFactory().createValue(NodeTypeUtil.getValueOfType(this.session, 5).getString());
        CanSetPropertyDateTest.assertTrue((String)"canSetProperty(String propertyName, Value value) must return true if the property is of type Date and value is a StringValue in date format", (boolean)nodeType.canSetProperty(propDef.getName(), dateStringValue));
        Value anyBinaryValue = NodeTypeUtil.getValueOfType(this.session, 2);
        CanSetPropertyDateTest.assertFalse((String)"canSetProperty(String propertyName, Value value) must return false if the property is of type Date and value is a UTF-8 BinaryValue not in date format", (boolean)nodeType.canSetProperty(propDef.getName(), anyBinaryValue));
        Value dateBinaryValue = this.superuser.getValueFactory().createValue(NodeTypeUtil.getValueOfType(this.session, 5).getString(), 2);
        CanSetPropertyDateTest.assertTrue((String)"canSetProperty(String propertyName, Value value) must return true if the property is of type Date and value is a UTF-8 BinaryValue in date format", (boolean)nodeType.canSetProperty(propDef.getName(), dateBinaryValue));
        Value dateValue = NodeTypeUtil.getValueOfType(this.session, 5);
        CanSetPropertyDateTest.assertTrue((String)"canSetProperty(String propertyName, Value value) must return true if the property is of type Date and value is a DateValue", (boolean)nodeType.canSetProperty(propDef.getName(), dateValue));
        Value doubleValue = NodeTypeUtil.getValueOfType(this.session, 4);
        CanSetPropertyDateTest.assertTrue((String)"canSetProperty(String propertyName, Value value) must return true if the property is of type Date and value is a DoubleValue", (boolean)nodeType.canSetProperty(propDef.getName(), doubleValue));
        Value longValue = NodeTypeUtil.getValueOfType(this.session, 3);
        CanSetPropertyDateTest.assertTrue((String)"canSetProperty(String propertyName, Value value) must return true if the property is of type Date and value is a LongValue", (boolean)nodeType.canSetProperty(propDef.getName(), longValue));
        Value booleanValue = NodeTypeUtil.getValueOfType(this.session, 6);
        CanSetPropertyDateTest.assertFalse((String)"canSetProperty(String propertyName, Value value) must return false if the property is of type Date and value is a BooleanValue", (boolean)nodeType.canSetProperty(propDef.getName(), booleanValue));
        Value nameValue = NodeTypeUtil.getValueOfType(this.session, 7);
        CanSetPropertyDateTest.assertFalse((String)"canSetProperty(String propertyName, Value value) must return false if the property is of type Date and value is a NameValue", (boolean)nodeType.canSetProperty(propDef.getName(), nameValue));
        Value pathValue = NodeTypeUtil.getValueOfType(this.session, 8);
        CanSetPropertyDateTest.assertFalse((String)"canSetProperty(String propertyName, Value value) must return false if the property is of type Date and value is a PathValue", (boolean)nodeType.canSetProperty(propDef.getName(), pathValue));
    }

    public void testConversionsMultiple() throws NotExecutableException, RepositoryException {
        PropertyDefinition propDef = NodeTypeUtil.locatePropertyDef(this.session, 5, true, false, false, false);
        if (propDef == null) {
            throw new NotExecutableException("No multiple string property def that meets the requirements of the test has been found");
        }
        NodeType nodeType = propDef.getDeclaringNodeType();
        Value dateValue = NodeTypeUtil.getValueOfType(this.session, 5);
        Value anyStringValue = NodeTypeUtil.getValueOfType(this.session, 1);
        Value[] anyStringValues = new Value[]{dateValue, anyStringValue};
        CanSetPropertyDateTest.assertFalse((String)"canSetProperty(String propertyName, Value[] values) must return false if the property is of type Date and values are of type StringValue not in date format", (boolean)nodeType.canSetProperty(propDef.getName(), anyStringValues));
        Value dateStringValue = this.superuser.getValueFactory().createValue(NodeTypeUtil.getValueOfType(this.session, 5).getString());
        Value[] dateStringValues = new Value[]{dateStringValue};
        CanSetPropertyDateTest.assertTrue((String)"canSetProperty(String propertyName, Value[] values) must return true if the property is of type Date and values are of type StringValue in date format", (boolean)nodeType.canSetProperty(propDef.getName(), dateStringValues));
        Value[] dateValues = new Value[]{dateValue};
        CanSetPropertyDateTest.assertTrue((String)"canSetProperty(String propertyName, Value[] values) must return true if the property is of type Date and values are of type DateValue", (boolean)nodeType.canSetProperty(propDef.getName(), dateValues));
        Value anyBinaryValue = NodeTypeUtil.getValueOfType(this.session, 2);
        Value[] anyBinaryValues = new Value[]{dateValue, anyBinaryValue};
        CanSetPropertyDateTest.assertFalse((String)"canSetProperty(String propertyName, Value[] values) must return false if the property is of type Date and values are of type BinaryValuein UTF-8 but not in date format", (boolean)nodeType.canSetProperty(propDef.getName(), anyBinaryValues));
        Value dateBinaryValue = this.superuser.getValueFactory().createValue(NodeTypeUtil.getValueOfType(this.session, 5).getString(), 2);
        Value[] dateBinaryValues = new Value[]{dateBinaryValue};
        CanSetPropertyDateTest.assertTrue((String)"canSetProperty(String propertyName, Value[] values) must return true if the property is of type Date and values are of type BinaryValuein UTF-8 and in date format", (boolean)nodeType.canSetProperty(propDef.getName(), dateBinaryValues));
        Value doubleValue = NodeTypeUtil.getValueOfType(this.session, 4);
        Value[] doubleValues = new Value[]{doubleValue};
        CanSetPropertyDateTest.assertTrue((String)"canSetProperty(String propertyName, Value[] values) must return true if the property is of type Date and values are of type DoubleValue", (boolean)nodeType.canSetProperty(propDef.getName(), doubleValues));
        Value longValue = NodeTypeUtil.getValueOfType(this.session, 3);
        Value[] longValues = new Value[]{longValue};
        CanSetPropertyDateTest.assertTrue((String)"canSetProperty(String propertyName, Value[] values) must return true if the property is of type Date and values are of type LongValue", (boolean)nodeType.canSetProperty(propDef.getName(), longValues));
        Value booleanValue = NodeTypeUtil.getValueOfType(this.session, 6);
        Value[] booleanValues = new Value[]{dateValue, booleanValue};
        CanSetPropertyDateTest.assertFalse((String)"canSetProperty(String propertyName, Value[] values) must return false if the property is of type Date and values are of type BooleanValue", (boolean)nodeType.canSetProperty(propDef.getName(), booleanValues));
        Value nameValue = NodeTypeUtil.getValueOfType(this.session, 7);
        Value[] nameValues = new Value[]{dateValue, nameValue};
        CanSetPropertyDateTest.assertFalse((String)"canSetProperty(String propertyName, Value[] values) must return false if the property is of type Date and values are of type NameValue", (boolean)nodeType.canSetProperty(propDef.getName(), nameValues));
        Value pathValue = NodeTypeUtil.getValueOfType(this.session, 8);
        Value[] pathValues = new Value[]{dateValue, pathValue};
        CanSetPropertyDateTest.assertFalse((String)"canSetProperty(String propertyName, Value[] values) must return false if the property is of type Date and values are of type PathValue", (boolean)nodeType.canSetProperty(propDef.getName(), pathValues));
    }

    public void testValueConstraintNotSatisfied() throws NotExecutableException, ParseException, RepositoryException {
        PropertyDefinition propDef = NodeTypeUtil.locatePropertyDef(this.session, 5, false, false, true, false);
        if (propDef == null) {
            throw new NotExecutableException("No date property def with testable value constraints has been found");
        }
        Value value = NodeTypeUtil.getValueAccordingToValueConstraints(this.session, propDef, false);
        if (value == null) {
            throw new NotExecutableException("No date property def with testable value constraints has been found");
        }
        NodeType nodeType = propDef.getDeclaringNodeType();
        CanSetPropertyDateTest.assertFalse((String)"canSetProperty(String propertyName, Value value) must return false if value does not match the value constraints.", (boolean)nodeType.canSetProperty(propDef.getName(), value));
    }

    public void testValueConstraintNotSatisfiedMultiple() throws NotExecutableException, ParseException, RepositoryException {
        PropertyDefinition propDef = NodeTypeUtil.locatePropertyDef(this.session, 5, true, false, true, false);
        if (propDef == null) {
            throw new NotExecutableException("No multiple date property def with testable value constraints has been found");
        }
        Value value = NodeTypeUtil.getValueAccordingToValueConstraints(this.session, propDef, false);
        if (value == null) {
            throw new NotExecutableException("No multiple date property def with testable value constraints has been found");
        }
        NodeType nodeType = propDef.getDeclaringNodeType();
        Value[] values = new Value[]{value};
        CanSetPropertyDateTest.assertFalse((String)"canSetProperty(String propertyName, Value[] values) must return false if values do not match the value constraints.", (boolean)nodeType.canSetProperty(propDef.getName(), values));
    }
}

