/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.test.api.observation;

import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.nodetype.NodeType;
import javax.jcr.observation.Event;
import org.apache.jackrabbit.test.NotExecutableException;
import org.apache.jackrabbit.test.api.observation.AbstractObservationTest;
import org.apache.jackrabbit.test.api.observation.EventResult;

public class PropertyChangedTest
extends AbstractObservationTest {
    public void testSinglePropertyChanged() throws RepositoryException {
        Node node = this.testRootNode.addNode(this.nodeName1, this.testNodeType);
        node.setProperty(this.propertyName1, "foo");
        this.testRootNode.save();
        EventResult result = new EventResult(this.log);
        this.addEventListener(result, 16);
        node.getProperty(this.propertyName1).setValue("foobar");
        this.testRootNode.save();
        Event[] events = result.getEvents(5000L);
        this.removeEventListener(result);
        this.checkPropertyChanged(events, new String[]{this.nodeName1 + "/" + this.propertyName1});
    }

    public void testMultiPropertyChanged() throws RepositoryException {
        Node node = this.testRootNode.addNode(this.nodeName1, this.testNodeType);
        node.setProperty(this.propertyName1, "foo");
        node.setProperty(this.propertyName2, "bar");
        this.testRootNode.save();
        EventResult result = new EventResult(this.log);
        this.addEventListener(result, 16);
        node.getProperty(this.propertyName1).setValue("foobar");
        node.getProperty(this.propertyName2).setValue("foobar");
        this.testRootNode.save();
        Event[] events = result.getEvents(5000L);
        this.removeEventListener(result);
        this.checkPropertyChanged(events, new String[]{this.nodeName1 + "/" + this.propertyName1, this.nodeName1 + "/" + this.propertyName2});
    }

    public void testSinglePropertyChangedWithAdded() throws RepositoryException {
        Node node = this.testRootNode.addNode(this.nodeName1, this.testNodeType);
        node.setProperty(this.propertyName1, "foo");
        this.testRootNode.save();
        EventResult result = new EventResult(this.log);
        this.addEventListener(result, 16);
        node.getProperty(this.propertyName1).setValue("foobar");
        node.setProperty(this.propertyName2, "bar");
        this.testRootNode.save();
        Event[] events = result.getEvents(5000L);
        this.removeEventListener(result);
        this.checkPropertyChanged(events, new String[]{this.nodeName1 + "/" + this.propertyName1});
    }

    public void testPropertyRemoveCreate() throws RepositoryException, NotExecutableException {
        Node n = this.testRootNode.addNode(this.nodeName1, this.testNodeType);
        NodeType nt = this.superuser.getWorkspace().getNodeTypeManager().getNodeType(this.testNodeType);
        Value v1 = this.superuser.getValueFactory().createValue("foo");
        Value v2 = this.superuser.getValueFactory().createValue(System.currentTimeMillis());
        if (!nt.canSetProperty(this.propertyName1, v1) || !nt.canSetProperty(this.propertyName1, v2)) {
            throw new NotExecutableException("Property " + this.propertyName1 + " is not of type UNDEFINED");
        }
        n.setProperty(this.propertyName1, v1);
        this.testRootNode.save();
        EventResult result = new EventResult(this.log);
        this.addEventListener(result, 28);
        n.getProperty(this.propertyName1).remove();
        n.setProperty(this.propertyName1, v2);
        this.testRootNode.save();
        Event[] events = result.getEvents(5000L);
        this.removeEventListener(result);
        if (events.length == 1) {
            this.checkPropertyChanged(events, new String[]{this.nodeName1 + "/" + this.propertyName1});
        } else {
            PropertyChangedTest.assertEquals((String)"Expected 2 events for a property type change.", (int)2, (int)events.length);
            int type = 12;
            String path = this.testRoot + "/" + this.nodeName1 + "/" + this.propertyName1;
            for (int i = 0; i < events.length; ++i) {
                PropertyChangedTest.assertTrue((String)"Event is not of type PROPERTY_REMOVED or PROPERTY_ADDED", ((events[i].getType() & type) > 0 ? 1 : 0) != 0);
                PropertyChangedTest.assertEquals((String)"Path for event is wrong.", (String)path, (String)events[i].getPath());
            }
        }
    }
}

