/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.test.api.query;

import javax.jcr.Node;
import javax.jcr.query.Query;
import javax.jcr.query.QueryResult;
import org.apache.jackrabbit.test.api.query.AbstractOrderByTest;

public class OrderByMultiTypeTest
extends AbstractOrderByTest {
    public void testMultipleOrder() throws Exception {
        QueryResult result;
        Query q;
        Node n1 = this.testRootNode.addNode(this.nodeName1, this.testNodeType);
        Node n2 = this.testRootNode.addNode(this.nodeName2, this.testNodeType);
        Node n3 = this.testRootNode.addNode(this.nodeName3, this.testNodeType);
        n1.setProperty(this.propertyName1, "aaa");
        n1.setProperty(this.propertyName2, 3L);
        n2.setProperty(this.propertyName1, "bbb");
        n2.setProperty(this.propertyName2, 2L);
        n3.setProperty(this.propertyName1, "ccc");
        n3.setProperty(this.propertyName2, 2L);
        this.testRootNode.save();
        String sql = "SELECT " + this.propertyName2 + " FROM " + this.testNodeType + " WHERE " + this.jcrPath + " LIKE '" + this.testRoot + "/%' ORDER BY " + this.propertyName2 + ", " + this.propertyName1;
        if (this.checkSQL) {
            q = this.superuser.getWorkspace().getQueryManager().createQuery(sql, "sql");
            result = q.execute();
            this.checkResultOrder(result, new String[]{this.nodeName2, this.nodeName3, this.nodeName1});
        }
        String xpath = "/" + this.testRoot + "/*[@" + this.jcrPrimaryType + "='" + this.testNodeType + "'] order by @" + this.propertyName2 + ", @" + this.propertyName1;
        q = this.superuser.getWorkspace().getQueryManager().createQuery(xpath, "xpath");
        result = q.execute();
        this.checkResultOrder(result, new String[]{this.nodeName2, this.nodeName3, this.nodeName1});
        sql = "SELECT " + this.propertyName2 + " FROM " + this.testNodeType + " WHERE " + this.jcrPath + " LIKE '" + this.testRoot + "/%' ORDER BY " + this.propertyName2 + " DESC, " + this.propertyName1 + " DESC";
        if (this.checkSQL) {
            q = this.superuser.getWorkspace().getQueryManager().createQuery(sql, "sql");
            result = q.execute();
            this.checkResultOrder(result, new String[]{this.nodeName1, this.nodeName3, this.nodeName2});
        }
        xpath = "/" + this.jcrRoot + this.testRoot + "/*[@" + this.jcrPrimaryType + "='" + this.testNodeType + "'] order by @" + this.propertyName2 + " descending, @" + this.propertyName1 + " descending";
        q = this.superuser.getWorkspace().getQueryManager().createQuery(xpath, "xpath");
        result = q.execute();
        this.checkResultOrder(result, new String[]{this.nodeName1, this.nodeName3, this.nodeName2});
        sql = "SELECT " + this.propertyName2 + " FROM " + this.testNodeType + " WHERE " + this.jcrPath + " LIKE '" + this.testRoot + "/%' ORDER BY " + this.propertyName2 + " DESC, " + this.propertyName1;
        if (this.checkSQL) {
            q = this.superuser.getWorkspace().getQueryManager().createQuery(sql, "sql");
            result = q.execute();
            this.checkResultOrder(result, new String[]{this.nodeName1, this.nodeName2, this.nodeName3});
        }
        xpath = "/" + this.jcrRoot + this.testRoot + "/*[@" + this.jcrPrimaryType + "='" + this.testNodeType + "'] order by @" + this.propertyName2 + " descending, @" + this.propertyName1;
        q = this.superuser.getWorkspace().getQueryManager().createQuery(xpath, "xpath");
        result = q.execute();
        this.checkResultOrder(result, new String[]{this.nodeName1, this.nodeName2, this.nodeName3});
    }
}

