/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.test.api.retention;

import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.retention.RetentionPolicy;
import org.apache.jackrabbit.test.NotExecutableException;
import org.apache.jackrabbit.test.api.retention.AbstractRetentionTest;

public class RetentionPolicyEffectTest
extends AbstractRetentionTest {
    private Node childN;
    private Property childP;
    private Session otherS;

    protected void setUp() throws Exception {
        super.setUp();
        this.childN = this.testRootNode.addNode(this.nodeName2);
        Value v = this.getJcrValue(this.superuser, "propertyvalue1", "propertytype1", "test");
        this.childP = this.testRootNode.setProperty(this.propertyName1, v);
        this.superuser.save();
        this.otherS = this.getHelper().getSuperuserSession();
    }

    protected void tearDown() throws Exception {
        if (this.otherS != null) {
            this.otherS.logout();
        }
        this.superuser.refresh(false);
        RetentionPolicy rp = this.retentionMgr.getRetentionPolicy(this.testNodePath);
        if (rp != null) {
            this.retentionMgr.removeRetentionPolicy(this.testNodePath);
            this.superuser.save();
        }
        super.tearDown();
    }

    public void testTransientRententionPolicy() throws RepositoryException, NotExecutableException {
        this.retentionMgr.setRetentionPolicy(this.testNodePath, this.getApplicableRetentionPolicy());
        this.assertNoEffect(this.testRootNode, this.nodeName3, this.propertyName2);
        this.assertNoEffect(this.childN, this.nodeName3, this.propertyName2);
        this.assertNoEffect(this.childP);
    }

    public void testTransientRententionPolicy2() throws RepositoryException, NotExecutableException {
        this.retentionMgr.setRetentionPolicy(this.testNodePath, this.getApplicableRetentionPolicy());
        this.assertNoEffect((Node)this.otherS.getItem(this.testNodePath), this.nodeName3, this.propertyName2);
        this.assertNoEffect((Node)this.otherS.getItem(this.childN.getPath()), this.nodeName3, this.propertyName2);
        this.assertNoEffect((Property)this.otherS.getItem(this.childP.getPath()));
    }

    public void testRententionPolicy() throws RepositoryException, NotExecutableException {
        this.retentionMgr.setRetentionPolicy(this.testNodePath, this.getApplicableRetentionPolicy());
        this.superuser.save();
        this.assertEffect(this.testRootNode, this.childN.getName(), this.childP.getName(), this.nodeName3, this.propertyName2);
    }

    public void testRententionPolicy2() throws RepositoryException, NotExecutableException {
        this.retentionMgr.setRetentionPolicy(this.testNodePath, this.getApplicableRetentionPolicy());
        this.superuser.save();
        this.assertEffect((Node)this.otherS.getItem(this.testNodePath), this.childN.getName(), this.childP.getName(), this.nodeName3, this.propertyName2);
    }

    private void assertEffect(Node targetNode, String childName, String propName, String childName2, String propName2) throws RepositoryException {
        Property p;
        Session s = targetNode.getSession();
        try {
            Node child = targetNode.getNode(childName);
            child.remove();
            s.save();
            RetentionPolicyEffectTest.fail((String)"Retention policy present must prevent a child node from being removed.");
        }
        catch (RepositoryException e) {
            s.refresh(false);
        }
        try {
            p = targetNode.getProperty(propName);
            p.remove();
            s.save();
            RetentionPolicyEffectTest.fail((String)"Retention policy present must prevent a child property from being removed.");
        }
        catch (RepositoryException e) {
            s.refresh(false);
        }
        try {
            p = targetNode.getProperty(propName);
            p.setValue("test2");
            s.save();
            RetentionPolicyEffectTest.fail((String)"Retention policy present must prevent the child property from being modified.");
        }
        catch (RepositoryException e) {
            s.refresh(false);
        }
        try {
            targetNode.addNode(childName2);
            s.save();
            RetentionPolicyEffectTest.fail((String)"Retention policy present must prevent the target node from having new nodes added.");
        }
        catch (RepositoryException e) {
            s.refresh(false);
        }
        try {
            Value v = this.getJcrValue(s, "propertyvalue2", "propertytype2", "test");
            targetNode.setProperty(propName2, v);
            s.save();
            RetentionPolicyEffectTest.fail((String)"Retention policy present must prevent the target node from having new properties set.");
        }
        catch (RepositoryException e) {
            s.refresh(false);
        }
        try {
            targetNode.remove();
            s.save();
            RetentionPolicyEffectTest.fail((String)"Hold present must prevent the target node from being removed.");
        }
        catch (RepositoryException e) {
            s.refresh(false);
        }
    }

    private void assertNoEffect(Node target, String childName, String propName) throws RepositoryException {
        Session s = target.getSession();
        Node n = target.addNode(childName);
        Value v = this.getJcrValue(s, "propertyvalue2", "propertytype2", "test");
        Property p = target.setProperty(propName, v);
        n.remove();
        p.remove();
    }

    private void assertNoEffect(Property target) throws RepositoryException {
        Session s = target.getSession();
        target.setValue("test3");
        target.remove();
    }
}

