/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.test.api.security;

import java.util.Arrays;
import java.util.List;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.security.AccessControlManager;
import javax.jcr.security.Privilege;
import org.apache.jackrabbit.test.NotExecutableException;
import org.apache.jackrabbit.test.api.security.AbstractAccessControlTest;

public class RSessionAccessControlDiscoveryTest
extends AbstractAccessControlTest {
    private Session readOnlySession;
    private AccessControlManager testAcMgr;
    private String testPath;

    protected void setUp() throws Exception {
        super.setUp();
        this.readOnlySession = this.getHelper().getReadOnlySession();
        this.testAcMgr = RSessionAccessControlDiscoveryTest.getAccessControlManager(this.readOnlySession);
        this.testPath = this.testRootNode.getPath();
    }

    protected void tearDown() throws Exception {
        if (this.readOnlySession != null) {
            this.readOnlySession.logout();
        }
        super.tearDown();
    }

    public void testGetSupportedPrivileges() throws RepositoryException {
        Privilege[] privileges = this.testAcMgr.getSupportedPrivileges(this.testPath);
        RSessionAccessControlDiscoveryTest.assertNotNull((String)"getSupportedPrivileges must return a non-null value even for read-only session.", (Object)privileges);
        RSessionAccessControlDiscoveryTest.assertTrue((String)"getSupportedPrivileges must return a non-empty array even for read-only session.", (privileges.length > 0 ? 1 : 0) != 0);
    }

    public void testGetPrivileges() throws RepositoryException {
        List<Privilege> privs = Arrays.asList(this.testAcMgr.getPrivileges(this.testPath));
        Privilege readPrivilege = this.testAcMgr.privilegeFromName("{http://www.jcp.org/jcr/1.0}read");
        RSessionAccessControlDiscoveryTest.assertTrue((String)"A read-only session must have READ access to the test node.", (boolean)privs.contains(readPrivilege));
    }

    public void testHasPrivileges() throws RepositoryException, NotExecutableException {
        Privilege priv = this.testAcMgr.privilegeFromName("{http://www.jcp.org/jcr/1.0}read");
        RSessionAccessControlDiscoveryTest.assertTrue((String)"Read-only session must have READ privilege on test node.", (boolean)this.testAcMgr.hasPrivileges(this.testPath, new Privilege[]{priv}));
    }

    public void testNotHasPrivileges() throws RepositoryException, NotExecutableException {
        Privilege all = this.testAcMgr.privilegeFromName("{http://www.jcp.org/jcr/1.0}all");
        RSessionAccessControlDiscoveryTest.assertFalse((String)"Read-only session must not have ALL privilege", (boolean)this.testAcMgr.hasPrivileges(this.testPath, new Privilege[]{all}));
    }
}

