/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.test.api.version;

import javax.jcr.Item;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Workspace;
import javax.jcr.version.Version;
import javax.jcr.version.VersionHistory;
import javax.jcr.version.VersionManager;
import org.apache.jackrabbit.test.api.version.simple.AbstractVersionTest;

public class CopyTest
extends AbstractVersionTest {
    protected void setUp() throws Exception {
        super.setUp();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void tearDown() throws Exception {
        try {
            try {
                String dstPath = this.getProperty("destination");
                this.superuser.getNode(dstPath).remove();
                this.testRootNode.getSession().save();
            }
            catch (Exception e) {
                this.log.println("Exception in tearDown: " + e.toString());
                Object var3_4 = null;
                super.tearDown();
                return;
            }
            Object var3_3 = null;
        }
        catch (Throwable throwable) {
            Object var3_5 = null;
            super.tearDown();
            throw throwable;
        }
        super.tearDown();
    }

    public void testCopy() throws RepositoryException {
        Workspace wsp = this.superuser.getWorkspace();
        VersionManager vMgr = wsp.getVersionManager();
        String srcPath = this.versionableNode.getPath();
        String dstPath = this.getProperty("destination");
        wsp.copy(srcPath, dstPath);
        Node v = this.superuser.getNode(dstPath);
        CopyTest.assertTrue((String)"Copied Node.isNodeType(mix:cersionable) must return true.", (boolean)v.isNodeType(this.mixVersionable));
        VersionHistory vh1 = vMgr.getVersionHistory(srcPath);
        VersionHistory vh2 = vMgr.getVersionHistory(dstPath);
        CopyTest.assertFalse((String)"Copied node needs a new version history.", (boolean)vh1.isSame((Item)vh2));
        CopyTest.assertEquals((String)"Copied node must have 1 version.", (long)1L, (long)this.getNumberOfVersions(vh2));
        CopyTest.assertTrue((String)"Version history of desination must have a jcr:copiedFrom property", (boolean)vh2.hasProperty(this.jcrCopiedFrom));
        Node ref = vh2.getProperty(this.jcrCopiedFrom).getNode();
        Version base = vMgr.getBaseVersion(srcPath);
        CopyTest.assertTrue((String)"jcr:copiedFrom must point to the base version of the original.", (boolean)ref.isSame((Item)base));
    }
}

