/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.test.api.version;

import javax.jcr.Item;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.Value;
import javax.jcr.version.Version;
import javax.jcr.version.VersionManager;
import org.apache.jackrabbit.test.api.version.AbstractVersionTest;

public class VersionGraphTest
extends AbstractVersionTest {
    public void testInitialBaseVersionPointsToRootVersion() throws RepositoryException {
        Version rV = this.versionableNode.getVersionHistory().getRootVersion();
        Version bV = this.versionableNode.getBaseVersion();
        VersionGraphTest.assertTrue((String)"After creation of a versionable node the node's baseVersion must point to the rootVersion in the version history.", (boolean)rV.isSame((Item)bV));
    }

    public void testInitialBaseVersionPointsToRootVersionJcr2() throws RepositoryException {
        VersionManager versionManager = this.versionableNode.getSession().getWorkspace().getVersionManager();
        String path = this.versionableNode.getPath();
        Version rV = versionManager.getVersionHistory(path).getRootVersion();
        Version bV = versionManager.getBaseVersion(path);
        VersionGraphTest.assertTrue((String)"After creation of a versionable node the node's baseVersion must point to the rootVersion in the version history.", (boolean)rV.isSame((Item)bV));
    }

    public void testInitialNodePredecessors() throws RepositoryException {
        Property predecessors = this.versionableNode.getProperty(this.jcrPredecessors);
        Value[] values = predecessors.getValues();
        Version rV = this.versionableNode.getVersionHistory().getRootVersion();
        if (values.length != 1) {
            VersionGraphTest.fail((String)"The jcr:predecessors property of a versionable node must be initialized to contain a single value");
        }
        Value initialVal = values[0];
        VersionGraphTest.assertTrue((String)"The jcr:predecessors property of a versionable node is initialized to contain a single UUID, that of the root version", (boolean)initialVal.equals(this.superuser.getValueFactory().createValue((Node)rV)));
    }

    public void testInitialNodePredecessorsJcr2() throws RepositoryException {
        Property predecessors = this.versionableNode.getProperty(this.jcrPredecessors);
        Value[] values = predecessors.getValues();
        Version rV = this.versionableNode.getSession().getWorkspace().getVersionManager().getVersionHistory(this.versionableNode.getPath()).getRootVersion();
        if (values.length != 1) {
            VersionGraphTest.fail((String)"The jcr:predecessors property of a versionable node must be initialized to contain a single value");
        }
        Value initialVal = values[0];
        VersionGraphTest.assertTrue((String)"The jcr:predecessors property of a versionable node is initialized to contain a single UUID, that of the root version", (boolean)initialVal.equals(this.superuser.getValueFactory().createValue((Node)rV)));
    }

    public void testRootVersionHasNoPredecessor() throws RepositoryException {
        Version[] predec = this.versionableNode.getVersionHistory().getRootVersion().getPredecessors();
        VersionGraphTest.assertTrue((String)"The root version may not have any predecessors.", (predec.length == 0 ? 1 : 0) != 0);
    }

    public void testRootVersionHasNoPredecessorJcr2() throws RepositoryException {
        Version[] predec = this.versionableNode.getSession().getWorkspace().getVersionManager().getVersionHistory(this.versionableNode.getPath()).getRootVersion().getPredecessors();
        VersionGraphTest.assertTrue((String)"The root version may not have any predecessors.", (predec.length == 0 ? 1 : 0) != 0);
    }

    public void testGetBaseVersionOnNonVersionableNode() throws RepositoryException {
        try {
            this.nonVersionableNode.getBaseVersion();
            VersionGraphTest.fail((String)"Node.getBaseVersion() must throw UnsupportedRepositoryOperationException if the node is not versionable.");
        }
        catch (UnsupportedRepositoryOperationException unsupportedRepositoryOperationException) {
            // empty catch block
        }
    }

    public void testGetBaseVersionOnNonVersionableNodeJcr2() throws RepositoryException {
        try {
            this.nonVersionableNode.getSession().getWorkspace().getVersionManager().getBaseVersion(this.nonVersionableNode.getPath());
            VersionGraphTest.fail((String)"Node.getBaseVersion() must throw UnsupportedRepositoryOperationException if the node is not versionable.");
        }
        catch (UnsupportedRepositoryOperationException unsupportedRepositoryOperationException) {
            // empty catch block
        }
    }
}

