/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.test.api.version.simple;

import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.version.Version;
import javax.jcr.version.VersionManager;
import org.apache.jackrabbit.test.NotExecutableException;
import org.apache.jackrabbit.test.api.version.simple.AbstractVersionTest;

public class FrozenNodeTest
extends AbstractVersionTest {
    protected void setUp() throws Exception {
        super.setUp();
        try {
            VersionManager versionManager = this.versionableNode.getSession().getWorkspace().getVersionManager();
            String path = this.versionableNode.getPath();
            versionManager.checkout(path);
        }
        catch (RepositoryException e) {
            this.cleanUp();
            throw e;
        }
    }

    public void testFrozenNodeUUUID() throws RepositoryException {
        VersionManager versionManager = this.versionableNode.getSession().getWorkspace().getVersionManager();
        String path = this.versionableNode.getPath();
        Version v = versionManager.checkin(path);
        Node n = v.getFrozenNode();
        String puuid = n.getProperty(this.jcrUUID).getValue().getString();
        String nuuid = n.getIdentifier();
        FrozenNodeTest.assertEquals((String)"jcr:uuid needs to be equal to the getIdentifier() return value.", (String)nuuid, (String)puuid);
    }

    public void testFrozenChildNodeUUUID() throws RepositoryException {
        this.versionableNode.addNode("child");
        this.versionableNode.getSession().save();
        VersionManager versionManager = this.versionableNode.getSession().getWorkspace().getVersionManager();
        String path = this.versionableNode.getPath();
        Version v = versionManager.checkin(path);
        Node n = v.getFrozenNode().getNode("child");
        String puuid = n.getProperty(this.jcrUUID).getValue().getString();
        String nuuid = n.getIdentifier();
        FrozenNodeTest.assertEquals((String)"jcr:uuid needs to be equal to the getIdentifier() return value.", (String)nuuid, (String)puuid);
    }

    public void testFrozenUUUID() throws RepositoryException, NotExecutableException {
        this.ensureMixinType(this.versionableNode, this.mixReferenceable);
        this.versionableNode.getSession().save();
        VersionManager versionManager = this.versionableNode.getSession().getWorkspace().getVersionManager();
        String path = this.versionableNode.getPath();
        Version v = versionManager.checkin(path);
        Node n = v.getFrozenNode();
        String fuuid = n.getProperty(this.jcrFrozenUuid).getValue().getString();
        String ruuid = this.versionableNode.getIdentifier();
        FrozenNodeTest.assertEquals((String)"jcr:frozenUuid needs to be equal to the getIdentifier() return value.", (String)ruuid, (String)fuuid);
    }

    public void testFrozenChildUUUID() throws RepositoryException, NotExecutableException {
        Node n1 = this.versionableNode.addNode("child");
        this.ensureMixinType(n1, this.mixReferenceable);
        this.versionableNode.getSession().save();
        VersionManager versionManager = this.versionableNode.getSession().getWorkspace().getVersionManager();
        String path = this.versionableNode.getPath();
        Version v = versionManager.checkin(path);
        Node n = v.getFrozenNode().getNode("child");
        String fuuid = n.getProperty(this.jcrFrozenUuid).getValue().getString();
        String ruuid = n1.getIdentifier();
        FrozenNodeTest.assertEquals((String)"jcr:frozenUuid needs to be equal to the getIdentifier() return value.", (String)ruuid, (String)fuuid);
    }

    public void testFrozenNodeNodeType() throws RepositoryException {
        VersionManager versionManager = this.versionableNode.getSession().getWorkspace().getVersionManager();
        String path = this.versionableNode.getPath();
        Version v = versionManager.checkin(path);
        Node n = v.getFrozenNode();
        String puuid = n.getProperty(this.jcrPrimaryType).getValue().getString();
        String nuuid = n.getPrimaryNodeType().getName();
        FrozenNodeTest.assertEquals((String)"jcr:primaryType needs to be equal to the getPrimaryNodeType() return value.", (String)nuuid, (String)puuid);
    }

    public void testFrozenChildNodeNodeType() throws RepositoryException {
        this.versionableNode.addNode("child");
        this.versionableNode.getSession().save();
        VersionManager versionManager = this.versionableNode.getSession().getWorkspace().getVersionManager();
        String path = this.versionableNode.getPath();
        Version v = versionManager.checkin(path);
        Node n = v.getFrozenNode().getNode("child");
        String puuid = n.getProperty(this.jcrPrimaryType).getValue().getString();
        String nuuid = n.getPrimaryNodeType().getName();
        FrozenNodeTest.assertEquals((String)"jcr:primaryType needs to be equal to the getPrimaryNodeType() return value.", (String)nuuid, (String)puuid);
    }

    public void testFrozenNodeType() throws RepositoryException {
        VersionManager versionManager = this.versionableNode.getSession().getWorkspace().getVersionManager();
        String path = this.versionableNode.getPath();
        Version v = versionManager.checkin(path);
        Node n = v.getFrozenNode();
        String fuuid = n.getProperty("jcr:frozenPrimaryType").getValue().getString();
        String ruuid = this.versionableNode.getPrimaryNodeType().getName();
        FrozenNodeTest.assertEquals((String)"jcr:frozenPrimaryType needs to be equal to the getPrimaryNodeType() return value.", (String)ruuid, (String)fuuid);
    }

    public void testFrozenChildNodeType() throws RepositoryException {
        Node n1 = this.versionableNode.addNode("child");
        this.versionableNode.getSession().save();
        VersionManager versionManager = this.versionableNode.getSession().getWorkspace().getVersionManager();
        String path = this.versionableNode.getPath();
        Version v = versionManager.checkin(path);
        Node n = v.getFrozenNode().getNode("child");
        String fuuid = n.getProperty("jcr:frozenPrimaryType").getValue().getString();
        String ruuid = n1.getPrimaryNodeType().getName();
        FrozenNodeTest.assertEquals((String)"jcr:frozenPrimaryType needs to be equal to the getPrimaryNodeType() return value.", (String)ruuid, (String)fuuid);
    }
}

