/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jorphan.io;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.jorphan.util.JOrphanUtils;
import org.apache.log.Logger;

public class TextFile
extends File {
    private static final long serialVersionUID = 240L;
    private static final Logger log = LoggingManager.getLoggerForClass();
    private String encoding = null;

    public TextFile(File filename, String encoding) {
        super(filename.toString());
        this.setEncoding(encoding);
    }

    public TextFile(File filename) {
        super(filename.toString());
    }

    public TextFile(String filename) {
        super(filename);
    }

    public TextFile(String filename, String encoding) {
        super(filename);
        this.setEncoding(encoding);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setText(String body) {
        OutputStreamWriter writer = null;
        try {
            writer = this.encoding == null ? new FileWriter(this) : new OutputStreamWriter((OutputStream)new FileOutputStream(this), this.encoding);
            writer.write(body);
            ((Writer)writer).flush();
        }
        catch (IOException ioe) {
            try {
                log.error("", (Throwable)ioe);
            }
            catch (Throwable throwable) {
                JOrphanUtils.closeQuietly(writer);
                throw throwable;
            }
            JOrphanUtils.closeQuietly(writer);
        }
        JOrphanUtils.closeQuietly(writer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getText() {
        String lineEnd = System.getProperty("line.separator");
        StringBuilder sb = new StringBuilder();
        InputStreamReader reader = null;
        BufferedReader br = null;
        try {
            reader = this.encoding == null ? new FileReader(this) : new InputStreamReader((InputStream)new FileInputStream(this), this.encoding);
            br = new BufferedReader(reader);
            String line = "NOTNULL";
            while (line != null) {
                line = br.readLine();
                if (line == null) continue;
                sb.append(line + lineEnd);
            }
            JOrphanUtils.closeQuietly(br);
        }
        catch (IOException ioe) {
            log.error("", (Throwable)ioe);
        }
        finally {
            JOrphanUtils.closeQuietly(br);
        }
        return sb.toString();
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String string) {
        this.encoding = string;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.encoding == null ? 0 : this.encoding.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof TextFile)) {
            return false;
        }
        TextFile other = (TextFile)obj;
        if (this.encoding == null) {
            return other.encoding == null;
        }
        return this.encoding.equals(other.encoding);
    }
}

