/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.surefire.report;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.List;
import org.apache.maven.plugin.surefire.report.FileReporterUtils;
import org.apache.maven.plugin.surefire.report.TestSetStats;
import org.apache.maven.plugin.surefire.report.WrappedReportEntry;
import org.apache.maven.surefire.report.ReportEntry;
import org.apache.maven.surefire.report.ReporterException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileReporter {
    private final File reportsDirectory;
    private final boolean deleteOnStarting;
    private final String reportNameSuffix;

    public FileReporter(File reportsDirectory, String reportNameSuffix) {
        this.reportsDirectory = reportsDirectory;
        this.deleteOnStarting = false;
        this.reportNameSuffix = reportNameSuffix;
    }

    private PrintWriter testSetStarting(ReportEntry report) {
        File reportFile = FileReporter.getReportFile(this.reportsDirectory, report.getName(), this.reportNameSuffix, ".txt");
        File reportDir = reportFile.getParentFile();
        reportDir.mkdirs();
        if (this.deleteOnStarting && reportFile.exists()) {
            reportFile.delete();
        }
        try {
            PrintWriter writer = new PrintWriter(new FileWriter(reportFile));
            writer.println("-------------------------------------------------------------------------------");
            writer.println("Test set: " + report.getName());
            writer.println("-------------------------------------------------------------------------------");
            return writer;
        }
        catch (IOException e) {
            throw new ReporterException("Unable to create file for report: " + e.getMessage(), (Exception)e);
        }
    }

    public static File getReportFile(File reportsDirectory, String reportEntryName, String reportNameSuffix, String fileExtension) {
        File reportFile = reportNameSuffix != null && reportNameSuffix.length() > 0 ? new File(reportsDirectory, FileReporterUtils.stripIllegalFilenameChars(reportEntryName + "-" + reportNameSuffix + fileExtension)) : new File(reportsDirectory, FileReporterUtils.stripIllegalFilenameChars(reportEntryName + fileExtension));
        return reportFile;
    }

    public void testSetCompleted(WrappedReportEntry report, TestSetStats testSetStats, List<String> testResults) {
        PrintWriter writer = this.testSetStarting(report);
        writer.print(testSetStats.getTestSetSummary(report));
        if (testResults != null) {
            for (String testResult : testResults) {
                writer.println(testResult);
            }
        }
        writer.flush();
        writer.close();
    }
}

