/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.naming;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import javax.naming.ServiceUnavailableException;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.util.tracker.ServiceTracker;

public class ProxyInvocationHandler
implements InvocationHandler {
    public static final long TIMEOUT = 5000L;
    private String listenerFilter;
    private ServiceTracker tracker;

    public ProxyInvocationHandler(BundleContext bundleContext, String filter) throws InvalidSyntaxException {
        this.listenerFilter = filter;
        this.tracker = new ServiceTracker(bundleContext, bundleContext.createFilter(filter), null);
        this.tracker.open();
    }

    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        return method.invoke(this.getTarget(true), args);
    }

    public Object getTarget(boolean wait) throws InterruptedException, ServiceUnavailableException {
        Object svc = this.tracker.getService();
        if (svc == null && wait) {
            svc = this.tracker.waitForService(5000L);
        }
        if (svc == null) {
            throw new ServiceUnavailableException(this.listenerFilter);
        }
        return svc;
    }

    protected void finalize() throws Throwable {
        this.tracker.close();
        super.finalize();
    }
}

