/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.jbi.deployer.artifacts;

import java.io.File;
import java.util.ArrayList;
import javax.jbi.JBIException;
import javax.jbi.management.DeploymentException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.servicemix.jbi.deployer.Component;
import org.apache.servicemix.jbi.deployer.ServiceAssembly;
import org.apache.servicemix.jbi.deployer.ServiceUnit;
import org.apache.servicemix.jbi.deployer.artifacts.ComponentImpl;
import org.apache.servicemix.jbi.deployer.artifacts.ServiceAssemblyImpl;
import org.apache.servicemix.jbi.deployer.descriptor.ServiceUnitDesc;
import org.apache.servicemix.jbi.deployer.utils.ManagementSupport;
import org.w3c.dom.Element;

public class ServiceUnitImpl
implements ServiceUnit {
    protected final Log LOGGER = LogFactory.getLog(this.getClass());
    private ServiceUnitDesc serviceUnitDesc;
    private File rootDir;
    private ComponentImpl component;
    private ServiceAssemblyImpl serviceAssembly;

    public ServiceUnitImpl(ServiceUnitDesc serviceUnitDesc, File rootDir, ComponentImpl component) {
        this.serviceUnitDesc = serviceUnitDesc;
        this.rootDir = rootDir;
        this.component = component;
    }

    public String getKey() {
        return this.getComponentName() + "/" + this.getName();
    }

    public String getName() {
        return this.serviceUnitDesc.getIdentification().getName();
    }

    public String getDescription() {
        return this.serviceUnitDesc.getIdentification().getDescription();
    }

    public String getDescriptor() {
        throw new UnsupportedOperationException();
    }

    public String getComponentName() {
        return this.serviceUnitDesc.getTarget().getComponentName();
    }

    public ServiceAssembly getServiceAssembly() {
        return this.serviceAssembly;
    }

    protected ServiceAssemblyImpl getServiceAssemblyImpl() {
        return this.serviceAssembly;
    }

    protected void setServiceAssemblyImpl(ServiceAssemblyImpl serviceAssembly) {
        this.serviceAssembly = serviceAssembly;
    }

    public Component getComponent() {
        return this.component;
    }

    public ComponentImpl getComponentImpl() {
        return this.component;
    }

    public File getRootDir() {
        return this.rootDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deploy() throws JBIException {
        ClassLoader oldCl = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.component.getComponentClassLoader());
            String resultMsg = this.component.getComponent().getServiceUnitManager().deploy(this.getName(), this.getRootDir() != null ? this.getRootDir().getAbsolutePath() : null);
            ArrayList<Element> results = new ArrayList<Element>();
            if (!ManagementSupport.getComponentTaskResult(resultMsg, this.getComponentName(), results)) {
                throw ManagementSupport.failure("deploy", results);
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldCl);
        }
        this.component.addServiceUnit(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() throws JBIException {
        ClassLoader oldCl = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.component.getComponentClassLoader());
            this.component.getComponent().getServiceUnitManager().init(this.getName(), this.getRootDir() != null ? this.getRootDir().getAbsolutePath() : null);
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldCl);
        }
        this.component.addServiceUnit(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws JBIException {
        this.checkComponentStarted("start");
        ClassLoader oldCl = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.component.getComponentClassLoader());
            this.component.getComponent().getServiceUnitManager().start(this.getName());
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldCl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() throws JBIException {
        this.checkComponentStarted("stop");
        ClassLoader oldCl = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.component.getComponentClassLoader());
            this.component.getComponent().getServiceUnitManager().stop(this.getName());
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldCl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() throws JBIException {
        this.checkComponentStartedOrStopped("shutDown");
        ClassLoader oldCl = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.component.getComponentClassLoader());
            this.component.getComponent().getServiceUnitManager().shutDown(this.getName());
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldCl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void undeploy() throws JBIException {
        ClassLoader oldCl = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.component.getComponentClassLoader());
            String resultMsg = this.component.getComponent().getServiceUnitManager().undeploy(this.getName(), this.getRootDir() != null ? this.getRootDir().getAbsolutePath() : null);
            ArrayList<Element> results = new ArrayList<Element>();
            if (!ManagementSupport.getComponentTaskResult(resultMsg, this.getComponentName(), results)) {
                throw ManagementSupport.failure("undeploy", results);
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldCl);
        }
        this.component.removeServiceUnit(this);
    }

    protected void checkComponentStarted(String task) throws DeploymentException {
        if (!"Started".equals(this.component.getCurrentState())) {
            throw new DeploymentException("Component " + this.component.getName() + " is not started!");
        }
    }

    protected void checkComponentStartedOrStopped(String task) throws DeploymentException {
        if (!"Started".equals(this.component.getCurrentState()) && !"Stopped".equals(this.component.getCurrentState())) {
            throw new DeploymentException("Component " + this.component.getName() + " is shut down!");
        }
    }
}

