/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;

public final class FileUtil {
    private FileUtil() {
    }

    public static void moveFile(File src, File targetDirectory) throws IOException {
        if (!(src != null && src.exists() && src.isFile() && targetDirectory != null && targetDirectory.exists() && targetDirectory.isDirectory() && src.renameTo(new File(targetDirectory, src.getName())))) {
            throw new IOException("Failed to move " + src + " to " + targetDirectory);
        }
    }

    public static File getDirectoryPath(File parent, String subDirectory) {
        File result = null;
        if (parent != null) {
            result = new File(parent, subDirectory);
        }
        return result;
    }

    public static boolean buildDirectory(File file) {
        return file.exists() || file.mkdirs();
    }

    public static int countFilesInDirectory(File directory) {
        int count = 0;
        for (File file : directory.listFiles()) {
            if (file.isFile()) {
                ++count;
            }
            if (!file.isDirectory()) continue;
            count += FileUtil.countFilesInDirectory(file);
        }
        return count;
    }

    public static void copyInputStream(InputStream in, OutputStream out) throws IOException {
        FileUtil.fastCopy(in, out);
    }

    public static File unpackArchive(File theFile, File targetDir) throws IOException {
        if (!theFile.exists()) {
            throw new IOException(theFile.getAbsolutePath() + " does not exist");
        }
        if (!FileUtil.buildDirectory(targetDir)) {
            throw new IOException("Could not create directory: " + targetDir);
        }
        ZipFile zipFile = new ZipFile(theFile);
        Enumeration<? extends ZipEntry> entries = zipFile.entries();
        while (entries.hasMoreElements()) {
            ZipEntry entry = entries.nextElement();
            File file = new File(targetDir, File.separator + entry.getName());
            if (!FileUtil.buildDirectory(file.getParentFile())) {
                throw new IOException("Could not create directory: " + file.getParentFile());
            }
            if (!entry.isDirectory()) {
                FileUtil.copyInputStream(zipFile.getInputStream(entry), new BufferedOutputStream(new FileOutputStream(file)));
                continue;
            }
            if (FileUtil.buildDirectory(file)) continue;
            throw new IOException("Could not create directory: " + file);
        }
        zipFile.close();
        return theFile;
    }

    public static File unpackArchive(URL url, File targetDir) throws IOException {
        if (!targetDir.exists()) {
            targetDir.mkdirs();
        }
        BufferedInputStream in = new BufferedInputStream(url.openStream());
        File zip = File.createTempFile("arc", ".zip", targetDir);
        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(zip));
        FileUtil.copyInputStream(in, out);
        ((OutputStream)out).close();
        return FileUtil.unpackArchive(zip, targetDir);
    }

    public static boolean archiveContainsEntry(File theFile, String name) throws IOException {
        boolean result = false;
        ZipFile zipFile = new ZipFile(theFile);
        Enumeration<? extends ZipEntry> entries = zipFile.entries();
        while (entries.hasMoreElements()) {
            ZipEntry entry = entries.nextElement();
            if (!entry.getName().equals(name)) continue;
            result = true;
            break;
        }
        zipFile.close();
        return result;
    }

    public static synchronized File createUniqueDirectory(File rootDir, String seed) throws IOException {
        int index = seed.lastIndexOf(46);
        if (index > 0) {
            seed = seed.substring(0, index);
        }
        File result = null;
        int count = 0;
        while (result == null) {
            String name = seed + "." + count + ".tmp";
            File file = new File(rootDir, name);
            if (!file.exists()) {
                file.mkdirs();
                result = file;
            }
            ++count;
        }
        return result;
    }

    public static boolean deleteFile(File fileToDelete) {
        if (fileToDelete == null || !fileToDelete.exists()) {
            return true;
        }
        boolean result = true;
        if (fileToDelete.isDirectory()) {
            File[] files = fileToDelete.listFiles();
            if (files == null) {
                result = false;
            } else {
                for (int i = 0; i < files.length; ++i) {
                    File file = files[i];
                    if (file.getName().equals(".") || file.getName().equals("..")) continue;
                    if (file.isDirectory()) {
                        result &= FileUtil.deleteFile(file);
                        continue;
                    }
                    result &= file.delete();
                }
            }
        }
        return result &= fileToDelete.delete();
    }

    public static void zipDir(String directory, String zipName) throws IOException {
        ZipOutputStream zos = new ZipOutputStream(new FileOutputStream(zipName));
        String path = "";
        FileUtil.zipDir(directory, zos, path);
        zos.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void zipDir(String directory, ZipOutputStream zos, String path) throws IOException {
        File zipDir = new File(directory);
        String[] dirList = zipDir.list();
        byte[] readBuffer = new byte[2156];
        int bytesIn = 0;
        for (int i = 0; i < dirList.length; ++i) {
            File f = new File(zipDir, dirList[i]);
            if (f.isDirectory()) {
                String filePath = f.getPath();
                FileUtil.zipDir(filePath, zos, path + f.getName() + "/");
                continue;
            }
            FileInputStream fis = new FileInputStream(f);
            try {
                ZipEntry anEntry = new ZipEntry(path + f.getName());
                zos.putNextEntry(anEntry);
                bytesIn = fis.read(readBuffer);
                while (bytesIn != -1) {
                    zos.write(readBuffer, 0, bytesIn);
                    bytesIn = fis.read(readBuffer);
                }
                continue;
            }
            finally {
                fis.close();
            }
        }
    }

    public static boolean isFileFullyAvailable(String path) {
        return FileUtil.isFileFullyAvailable(new File(path));
    }

    public static boolean isFileFullyAvailable(File file) {
        long targetLength = file.length();
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        long target2Length = file.length();
        return targetLength == target2Length;
    }

    public static void fastCopy(InputStream input, OutputStream output) throws IOException {
        ReadableByteChannel src = Channels.newChannel(input);
        WritableByteChannel dest = Channels.newChannel(output);
        ByteBuffer buffer = ByteBuffer.allocateDirect(16384);
        while (src.read(buffer) != -1) {
            buffer.flip();
            dest.write(buffer);
            buffer.compact();
        }
        buffer.flip();
        while (buffer.hasRemaining()) {
            dest.write(buffer);
        }
        src.close();
        dest.close();
    }
}

