/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.nmr.audit.lucene;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.apache.servicemix.nmr.api.Exchange;
import org.apache.servicemix.nmr.api.Message;
import org.apache.servicemix.nmr.api.Status;
import org.apache.servicemix.nmr.api.Type;
import org.apache.servicemix.nmr.api.event.ExchangeListener;
import org.apache.servicemix.nmr.audit.AbstractAuditor;
import org.apache.servicemix.nmr.audit.AuditorException;
import org.apache.servicemix.nmr.audit.AuditorMBean;
import org.apache.servicemix.nmr.audit.AuditorQueryMBean;
import org.apache.servicemix.nmr.audit.lucene.DefaultLuceneCallback;
import org.apache.servicemix.nmr.audit.lucene.LuceneIndexer;
import org.apache.servicemix.nmr.core.util.StringSource;

public class LuceneAuditor
extends AbstractAuditor
implements AuditorQueryMBean {
    public static final String FIELD_ID = "id";
    public static final String FIELD_STATUS = "status";
    public static final String FIELD_MEP = "mep";
    public static final String FIELD_ROLE = "role";
    public static final String FIELD_PROPERTIES = "properties";
    public static final String FIELD_CONTENT = "content";
    private AuditorMBean delegatedAuditor;
    private LuceneIndexer luceneIndexer;

    public LuceneIndexer getLuceneIndexer() {
        return this.luceneIndexer;
    }

    public void setLuceneIndexer(LuceneIndexer luceneIndexer) {
        this.luceneIndexer = luceneIndexer;
    }

    public AuditorMBean getDelegatedAuditor() {
        return this.delegatedAuditor;
    }

    public void setDelegatedAuditor(AuditorMBean delegatedAuditor) {
        this.delegatedAuditor = delegatedAuditor;
    }

    public int getExchangeCount() throws AuditorException {
        return this.delegatedAuditor.getExchangeCount();
    }

    public String[] getExchangeIdsByRange(int fromIndex, int toIndex) throws AuditorException {
        return this.delegatedAuditor.getExchangeIdsByRange(fromIndex, toIndex);
    }

    public Exchange[] getExchangesByIds(String[] ids) throws AuditorException {
        return this.delegatedAuditor.getExchangesByIds(ids);
    }

    public int deleteExchangesByRange(int fromIndex, int toIndex) throws AuditorException {
        return this.delegatedAuditor.deleteExchangesByRange(fromIndex, toIndex);
    }

    public int deleteExchangesByIds(String[] ids) throws AuditorException {
        try {
            this.luceneIndexer.remove(ids);
        }
        catch (IOException io) {
            throw new AuditorException(io);
        }
        return this.delegatedAuditor.deleteExchangesByIds(ids);
    }

    public void exchangeSent(Exchange exchange) {
        try {
            Document doc = this.createDocument(exchange);
            this.luceneIndexer.add(doc, exchange.getId());
            if (this.delegatedAuditor instanceof ExchangeListener) {
                ((ExchangeListener)this.delegatedAuditor).exchangeSent(exchange);
            }
        }
        catch (Exception e) {
            this.log.error((Object)"Error while adding to lucene", (Throwable)e);
        }
    }

    public String getDescription() {
        return "Lucene Auditor";
    }

    public String[] findExchangesIdsByQuery(String query) throws AuditorException {
        return this.getExchangeIds("", query);
    }

    public String[] findExchangesIdsByStatus(Status status) throws AuditorException {
        return this.getExchangeIds(FIELD_STATUS, String.valueOf(status));
    }

    public String[] findExchangesIdsByProperty(String property, String value) throws AuditorException {
        return this.getExchangeIds("properties." + property, value);
    }

    public String[] findExchangesIdsByMessageContent(String type, String content) throws AuditorException {
        return this.getExchangeIds(type.toLowerCase() + "." + FIELD_CONTENT, content);
    }

    public String[] findExchangesIdsByMessageHeader(String type, String property, String value) throws AuditorException {
        return this.getExchangeIds(type.toLowerCase() + "." + FIELD_PROPERTIES + "." + property, value);
    }

    protected Document createDocument(Exchange exchange) throws AuditorException {
        try {
            exchange.ensureReReadable();
            Document d = new Document();
            d.add((Fieldable)new Field(FIELD_ID, exchange.getId(), Field.Store.YES, Field.Index.NOT_ANALYZED));
            d.add((Fieldable)new Field(FIELD_MEP, String.valueOf(exchange.getPattern()).toLowerCase(), Field.Store.YES, Field.Index.NOT_ANALYZED));
            d.add((Fieldable)new Field(FIELD_STATUS, String.valueOf(exchange.getStatus()).toLowerCase(), Field.Store.YES, Field.Index.NOT_ANALYZED));
            d.add((Fieldable)new Field(FIELD_ROLE, String.valueOf(exchange.getRole()).toLowerCase(), Field.Store.YES, Field.Index.NOT_ANALYZED));
            this.addExchangePropertiesToDocument(exchange, d);
            Type[] types = new Type[]{Type.In, Type.Out, Type.Fault};
            for (int i = 0; i < types.length; ++i) {
                Message message = exchange.getMessage(types[i], false);
                if (message == null) continue;
                String text = this.getBodyAsText(message);
                if (text != null) {
                    d.add((Fieldable)new Field(types[i].toString().toLowerCase() + "." + FIELD_CONTENT, text, Field.Store.COMPRESS, Field.Index.ANALYZED));
                }
                this.addMessageHeadersToDocument(message, d, types[i]);
            }
            return d;
        }
        catch (Exception ex) {
            throw new AuditorException("Error while creating Lucene Document", ex);
        }
    }

    protected String getBodyAsText(Message message) {
        String text;
        StringSource src = (StringSource)message.getBody(StringSource.class);
        if (src != null) {
            text = src.getText();
        } else {
            text = (String)message.getBody(String.class);
            if (text == null && message.getBody() != null) {
                text = message.getBody().toString();
            }
        }
        return text;
    }

    protected void addExchangePropertiesToDocument(Exchange exchange, Document document) {
        for (Map.Entry entry : exchange.getProperties().entrySet()) {
            if (!(entry.getValue() instanceof String)) continue;
            document.add((Fieldable)new Field("properties." + (String)entry.getKey(), (String)entry.getValue(), Field.Store.YES, Field.Index.ANALYZED));
        }
    }

    protected void addMessageHeadersToDocument(Message message, Document document, Type type) {
        for (Map.Entry entry : message.getHeaders().entrySet()) {
            if (!(entry.getValue() instanceof String)) continue;
            document.add((Fieldable)new Field(type.toString().toLowerCase() + "." + FIELD_PROPERTIES + "." + (String)entry.getKey(), (String)entry.getValue(), Field.Store.YES, Field.Index.ANALYZED));
        }
    }

    public String[] getExchangeIds(String queryContent, String field) throws AuditorException {
        DefaultLuceneCallback dfc = new DefaultLuceneCallback(queryContent, field);
        try {
            return (String[])this.luceneIndexer.search(dfc);
        }
        catch (IOException e) {
            throw new AuditorException("Error while getting Exchange IDs", e);
        }
    }
}

