/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.jbi.runtime.impl;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.jbi.JBIException;
import javax.jbi.component.ComponentContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.servicemix.document.DocumentRepository;
import org.apache.servicemix.jbi.runtime.ComponentRegistry;
import org.apache.servicemix.jbi.runtime.ComponentWrapper;
import org.apache.servicemix.jbi.runtime.Environment;
import org.apache.servicemix.jbi.runtime.impl.ClientComponentContext;
import org.apache.servicemix.jbi.runtime.impl.ComponentContextImpl;
import org.apache.servicemix.nmr.api.NMR;
import org.apache.servicemix.nmr.core.ServiceRegistryImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComponentRegistryImpl
extends ServiceRegistryImpl<ComponentWrapper>
implements ComponentRegistry {
    private static final Log LOGGER = LogFactory.getLog(ComponentRegistryImpl.class);
    private NMR nmr;
    private DocumentRepository documentRepository;
    private Map<String, ComponentContextImpl> contexts = new ConcurrentHashMap<String, ComponentContextImpl>();
    private Environment environment;

    public NMR getNmr() {
        return this.nmr;
    }

    public void setNmr(NMR nmr) {
        this.nmr = nmr;
    }

    public Environment getEnvironment() {
        return this.environment;
    }

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }

    public DocumentRepository getDocumentRepository() {
        return this.documentRepository;
    }

    public void setDocumentRepository(DocumentRepository documentRepository) {
        this.documentRepository = documentRepository;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doRegister(ComponentWrapper component, Map<String, ?> properties) throws JBIException {
        LOGGER.info((Object)("JBI component registered with properties: " + properties));
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(component.getClass().getClassLoader());
        try {
            String name = (String)properties.get("NAME");
            ComponentContextImpl context = new ComponentContextImpl(this, component, properties);
            component.getComponent().getLifeCycle().init((ComponentContext)context);
            if (name != null) {
                this.contexts.put(name, context);
            } else {
                LOGGER.warn((Object)"Component has no name!");
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(cl);
        }
    }

    protected void doUnregister(ComponentWrapper component, Map<String, ?> properties) throws JBIException {
        ComponentContextImpl context;
        String name;
        LOGGER.info((Object)("JBI component unregistered with properties: " + properties));
        String string = name = properties != null ? (String)properties.get("NAME") : null;
        if (name != null && (context = this.contexts.remove(name)) != null) {
            context.destroy();
        }
    }

    @Override
    public ComponentWrapper getComponent(String name) {
        return this.contexts.get(name).getComponent();
    }

    @Override
    public ComponentContext createComponentContext() {
        return new ClientComponentContext(this);
    }
}

