/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.shell.config;

import java.util.Dictionary;
import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.apache.karaf.shell.config.ConfigCommandSupport;
import org.osgi.service.cm.ConfigurationAdmin;

@Command(scope="config", name="propappend", description="Appends the given value to an existing property or creates the property with the specified name and value.")
public class PropAppendCommand
extends ConfigCommandSupport {
    @Argument(index=0, name="name", description="The name of the property", required=true, multiValued=false)
    String prop;
    @Argument(index=1, name="value", description="The value to append to the property", required=true, multiValued=false)
    String value;

    protected void doExecute(ConfigurationAdmin admin) throws Exception {
        Dictionary props = this.getEditedProps();
        if (props == null) {
            System.err.println("No configuration is being edited. Run the edit command first");
        } else {
            Object currentValue = props.get(this.prop);
            if (currentValue == null) {
                props.put(this.prop, this.value);
            } else if (currentValue instanceof String) {
                props.put(this.prop, currentValue + this.value);
            } else {
                System.err.println("Append Failed: current value is not a String.");
            }
        }
    }
}

