/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.common.xbean;

import javax.jbi.JBIException;
import org.apache.servicemix.common.DefaultServiceUnit;
import org.springframework.context.support.AbstractXmlApplicationContext;

public class XBeanServiceUnit
extends DefaultServiceUnit {
    private ClassLoader classLoader;
    private AbstractXmlApplicationContext applicationContext;

    public AbstractXmlApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    public void setApplicationContext(AbstractXmlApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public void shutDown() throws Exception {
        super.shutDown();
        this.classLoader = null;
        try {
            if (this.applicationContext != null) {
                this.applicationContext.destroy();
            }
            this.applicationContext = null;
        }
        catch (Exception e) {
            throw new JBIException("Unable to close application context", (Throwable)e);
        }
    }

    public ClassLoader getConfigurationClassLoader() {
        ClassLoader cl;
        if (this.classLoader == null && this.applicationContext != null) {
            this.classLoader = this.applicationContext.getClassLoader();
        }
        if ((cl = this.classLoader) == null) {
            cl = Thread.currentThread().getContextClassLoader();
        }
        if (cl == null) {
            cl = this.getClass().getClassLoader();
        }
        return cl;
    }
}

