/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.nmr.osgi;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.servicemix.nmr.api.service.ServiceRegistry;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OsgiServiceRegistryTracker<T>
implements ServiceTrackerCustomizer {
    private BundleContext bundleContext;
    private ServiceRegistry<T> registry;
    private Class clazz;
    private ServiceTracker tracker;

    public BundleContext getBundleContext() {
        return this.bundleContext;
    }

    public void setBundleContext(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    public Class getInterface() {
        return this.clazz;
    }

    public void setInterface(Class clazz) {
        this.clazz = clazz;
    }

    public ServiceRegistry<T> getRegistry() {
        return this.registry;
    }

    public void setRegistry(ServiceRegistry<T> registry) {
        this.registry = registry;
    }

    public void init() throws Exception {
        this.tracker = new ServiceTracker(this.bundleContext, this.clazz.getName(), (ServiceTrackerCustomizer)this);
        this.tracker.open();
    }

    public void destroy() throws Exception {
        this.tracker.close();
    }

    public Object addingService(ServiceReference reference) {
        Object service = this.bundleContext.getService(reference);
        Map properties = OsgiServiceRegistryTracker.getServicePropertiesSnapshotAsMap(reference);
        this.registry.register(service, properties);
        return service;
    }

    public void modifiedService(ServiceReference reference, Object service) {
    }

    public void removedService(ServiceReference reference, Object service) {
        Map properties = OsgiServiceRegistryTracker.getServicePropertiesSnapshotAsMap(reference);
        this.registry.unregister(service, properties);
    }

    public static Map getServicePropertiesSnapshotAsMap(ServiceReference reference) {
        String[] keys = reference.getPropertyKeys();
        Map<String, Object> map = new LinkedHashMap<String, Object>(keys.length);
        for (int i = 0; i < keys.length; ++i) {
            map.put(keys[i], reference.getProperty(keys[i]));
        }
        map = Collections.unmodifiableMap(map);
        return map;
    }
}

