/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.transaction;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class BundleWideTxData {
    private String value;
    private List<Pattern> methodList = new ArrayList<Pattern>();
    private List<Pattern> beanList = new ArrayList<Pattern>();

    public BundleWideTxData(String value, String method, String bean) {
        this.value = value == null || value.isEmpty() ? "Required" : value;
        this.setupPatterns(method, bean);
    }

    private void setupPatterns(String method, String bean) {
        Pattern p;
        int i;
        if (method == null || method.isEmpty()) {
            method = "*";
        }
        if (bean == null || bean.isEmpty()) {
            bean = "*";
        }
        String[] names = method.split("[, \t]");
        for (i = 0; i < names.length; ++i) {
            p = Pattern.compile(names[i].replaceAll("\\*", ".*"));
            this.methodList.add(p);
        }
        names = bean.split("[, \t]");
        for (i = 0; i < names.length; ++i) {
            p = Pattern.compile(names[i].replaceAll("\\*", ".*"));
            this.beanList.add(p);
        }
    }

    public String getValue() {
        return this.value;
    }

    public List<Pattern> getMethod() {
        return this.methodList;
    }

    public List<Pattern> getBean() {
        return this.beanList;
    }
}

