/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.nmr.core.util;

import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Map;
import org.apache.servicemix.nmr.core.util.IteratorToEnumeration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapToDictionary<K, V>
extends Dictionary<K, V> {
    private final Map<K, V> m_map;

    public MapToDictionary(Map map) {
        if (map == null) {
            throw new IllegalArgumentException("Source map cannot be null.");
        }
        this.m_map = map;
    }

    @Override
    public Enumeration<V> elements() {
        return new IteratorToEnumeration<V>(this.m_map.values().iterator());
    }

    @Override
    public V get(Object key) {
        return this.m_map.get(key);
    }

    @Override
    public boolean isEmpty() {
        return this.m_map.isEmpty();
    }

    @Override
    public Enumeration<K> keys() {
        return new IteratorToEnumeration<K>(this.m_map.keySet().iterator());
    }

    @Override
    public V put(K key, V value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public V remove(Object key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int size() {
        return this.m_map.size();
    }

    public String toString() {
        return this.m_map.toString();
    }
}

