/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.transaction;

import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import org.apache.aries.transaction.TransactionManagerService;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.cm.ManagedServiceFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Activator
implements BundleActivator,
ManagedServiceFactory {
    private static final Logger log = LoggerFactory.getLogger((String)"org.apache.aries.transaction");
    private BundleContext bundleContext;
    private Map managers = new HashMap();

    public void start(BundleContext bundleContext) throws Exception {
        this.bundleContext = bundleContext;
        Hashtable<String, String> props = new Hashtable<String, String>();
        props.put("service.pid", this.getName());
        bundleContext.registerService(ManagedServiceFactory.class.getName(), (Object)this, props);
        Hashtable ht = new Hashtable();
        this.updated("initial", ht);
    }

    private void set(Hashtable ht, String key) {
        String o = this.bundleContext.getProperty(key);
        if (o == null && (o = System.getenv(key.toUpperCase().replaceAll(".", "_"))) == null) {
            return;
        }
        ht.put(key, o);
    }

    public void stop(BundleContext context) throws Exception {
        Iterator w = this.managers.values().iterator();
        while (w.hasNext()) {
            try {
                TransactionManagerService mgr = (TransactionManagerService)w.next();
                w.remove();
                mgr.close();
            }
            catch (Exception exception) {}
        }
    }

    public String getName() {
        return "org.apache.aries.transaction";
    }

    public void updated(String pid, Dictionary properties) throws ConfigurationException {
        this.deleted(pid);
        TransactionManagerService mgr = new TransactionManagerService(pid, properties, this.bundleContext);
        this.managers.put(pid, mgr);
        try {
            mgr.start();
        }
        catch (Exception e) {
            log.error("Error starting transaction manager", (Throwable)e);
        }
    }

    public void deleted(String pid) {
        TransactionManagerService mgr = (TransactionManagerService)this.managers.remove(pid);
        if (mgr != null) {
            try {
                mgr.close();
            }
            catch (Exception e) {
                log.error("Error stopping transaction manager", (Throwable)e);
            }
        }
    }
}

