/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.naming;

import java.lang.reflect.Field;
import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.naming.NoInitialContextException;
import javax.naming.spi.InitialContextFactory;
import javax.naming.spi.InitialContextFactoryBuilder;
import javax.naming.spi.NamingManager;
import org.apache.servicemix.naming.InitialContextFactoryWrapper;
import org.apache.servicemix.naming.InitialContextWrapper;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OSGiInitialContextFactoryBuilder
extends ServiceTracker
implements InitialContextFactoryBuilder,
InitialContextFactory {
    private Context osgiContext;

    public OSGiInitialContextFactoryBuilder(BundleContext bundleContext, Context osgiContext) throws NamingException {
        super(bundleContext, InitialContextFactoryBuilder.class.getName(), null);
        this.open();
        this.osgiContext = osgiContext;
        NamingManager.setInitialContextFactoryBuilder(this);
    }

    public void destroy() {
        this.close();
        try {
            for (Field field : NamingManager.class.getDeclaredFields()) {
                if (!InitialContextFactoryBuilder.class.equals(field.getType())) continue;
                field.setAccessible(true);
                field.set(null, null);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public InitialContextFactory createInitialContextFactory(Hashtable<?, ?> environment) throws NamingException {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Context getInitialContext(Hashtable<?, ?> environment) throws NamingException {
        Context toReturn = null;
        ServiceReference ref = this.context.getServiceReference(InitialContextFactoryWrapper.class.getName());
        if (ref != null) {
            try {
                InitialContextFactoryWrapper icf = (InitialContextFactoryWrapper)this.context.getService(ref);
                if (icf != null) {
                    toReturn = icf.getInitialContext(environment);
                }
            }
            finally {
                this.context.ungetService(ref);
            }
        }
        if (toReturn == null) {
            toReturn = new InitialContextWrapper(this.createContext(environment), this.osgiContext, environment);
        }
        return toReturn;
    }

    public Context createContext(Hashtable<?, ?> env) throws NamingException {
        NamingException e;
        boolean icfFactorySet;
        String icfFactory;
        ServiceReference ref;
        InitialContextFactory icf;
        block17: {
            ServiceReference[] refs;
            icf = null;
            ref = null;
            icfFactory = (String)env.get("java.naming.factory.initial");
            icfFactorySet = true;
            if (icfFactory == null) {
                icfFactory = InitialContextFactory.class.getName();
                icfFactorySet = false;
            }
            try {
                refs = this.context.getAllServiceReferences(icfFactory, null);
                if (refs != null) {
                    ref = refs[0];
                    icf = (InitialContextFactory)this.context.getService(ref);
                }
            }
            catch (InvalidSyntaxException e2) {
                NamingException e4 = new NamingException("Argh this should never happen :)");
                e4.initCause(e2);
                throw e4;
            }
            if (icf == null) {
                try {
                    refs = this.context.getAllServiceReferences(InitialContextFactoryBuilder.class.getName(), null);
                    if (refs == null) break block17;
                    for (ServiceReference icfbRef : refs) {
                        InitialContextFactoryBuilder builder = (InitialContextFactoryBuilder)this.context.getService(icfbRef);
                        icf = builder.createInitialContextFactory(env);
                        this.context.ungetService(icfbRef);
                        if (icf == null) {
                            continue;
                        }
                        break;
                    }
                }
                catch (InvalidSyntaxException e3) {
                    NamingException e4 = new NamingException("Argh this should never happen :)");
                    e4.initCause(e3);
                    throw e4;
                }
            }
        }
        if (icf == null && icfFactorySet) {
            NamingException e4;
            try {
                Class<?> clazz = Class.forName(icfFactory, true, Thread.currentThread().getContextClassLoader());
                icf = (InitialContextFactory)clazz.newInstance();
            }
            catch (ClassNotFoundException e11) {
                e = new NamingException("Argh this should never happen :)");
                e.initCause(e11);
                throw e;
            }
            catch (InstantiationException e2) {
                e4 = new NamingException("Argh this should never happen :)");
                e4.initCause(e2);
                throw e4;
            }
            catch (IllegalAccessException e1) {
                e4 = new NamingException("Argh this should never happen :)");
                e4.initCause(e1);
                throw e4;
            }
        }
        if (icf == null) {
            NoInitialContextException e3 = new NoInitialContextException("We could not find an InitialContextFactory to use");
            throw e3;
        }
        Context ctx = icf.getInitialContext(env);
        if (ref != null) {
            this.context.ungetService(ref);
        }
        if (ctx == null) {
            e = new NamingException("The ICF returned a null context");
            throw e;
        }
        return ctx;
    }
}

