/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.jbi.deployer.handler;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import org.apache.servicemix.jbi.deployer.handler.Parser;
import org.apache.servicemix.jbi.deployer.handler.Transformer;
import org.apache.servicemix.jbi.deployer.utils.FileUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Connection
extends URLConnection {
    private final Logger logger = LoggerFactory.getLogger(Connection.class);
    private final Parser parser;

    public Connection(URL url) throws MalformedURLException {
        super(url);
        this.parser = new Parser(url.getPath());
    }

    public void connect() {
    }

    public InputStream getInputStream() throws IOException {
        try {
            InputStream targetInputStream = this.parser.getJbiJarURL().openConnection().getInputStream();
            File jbiZipFile = File.createTempFile("jbi", ".zip");
            FileOutputStream jbiZip = new FileOutputStream(jbiZipFile);
            FileUtil.copyInputStream(targetInputStream, jbiZip);
            jbiZip.close();
            targetInputStream.close();
            File jbiBundle = File.createTempFile("jbi", ".jar");
            Transformer.transformToOSGiBundle(jbiZipFile, jbiBundle, this.parser.getJbiProperties());
            return new FileInputStream(jbiBundle);
        }
        catch (Exception e) {
            this.logger.error("Error opening jbi protocol artifact", (Throwable)e);
            throw (IOException)new IOException("Error opening jbi protocol artifact").initCause(e);
        }
    }
}

