/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.jbi.deployer.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Properties;
import org.apache.servicemix.jbi.deployer.impl.Storage;

public class SimpleStorage
implements Storage {
    private final File file;
    private final Properties props = new Properties();

    public SimpleStorage(File file) {
        this.file = file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load() throws IOException {
        if (this.file.exists()) {
            FileInputStream is = new FileInputStream(this.file);
            try {
                this.props.load(is);
            }
            finally {
                ((InputStream)is).close();
            }
        }
    }

    public String get(String key) {
        return this.props.getProperty(key);
    }

    public String get(String key, String def) {
        return this.props.getProperty(key, def);
    }

    public void put(String key, String value) {
        this.props.setProperty(key, value);
    }

    public void clear() {
        this.clear(null);
    }

    public void clear(String prefix) {
        if (prefix == null) {
            prefix = "";
        }
        Enumeration<?> e = this.props.propertyNames();
        while (e.hasMoreElements()) {
            String k = (String)e.nextElement();
            if (!k.startsWith(prefix)) continue;
            this.props.remove(k);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save() throws IOException {
        FileOutputStream os = new FileOutputStream(this.file);
        try {
            this.props.store(os, null);
        }
        finally {
            ((OutputStream)os).close();
        }
    }

    public Storage getStorage(String name) {
        return new SubStorage(this, name + ".");
    }

    static class SubStorage
    implements Storage {
        private final Storage parent;
        private final String prefix;

        public SubStorage(Storage parent, String prefix) {
            this.parent = parent;
            this.prefix = prefix;
        }

        public String get(String key) {
            return this.parent.get(this.prefix + key);
        }

        public String get(String key, String def) {
            return this.parent.get(this.prefix + key, def);
        }

        public void put(String key, String value) {
            this.parent.put(this.prefix + key, value);
        }

        public void clear() {
            this.clear(null);
        }

        public void clear(String prefix) {
            this.parent.clear(this.prefix + (prefix != null ? prefix : ""));
        }

        public void save() throws IOException {
            this.parent.save();
        }

        public Storage getStorage(String name) {
            return new SubStorage(this, name + ".");
        }
    }
}

