/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.transaction;

import java.lang.reflect.Method;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.apache.aries.blueprint.Interceptor;
import org.apache.aries.transaction.TransactionAttribute;
import org.apache.aries.transaction.TransactionToken;
import org.apache.aries.transaction.TxComponentMetaDataHelper;
import org.apache.aries.transaction.exception.TransactionRollbackException;
import org.osgi.service.blueprint.reflect.ComponentMetadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TxInterceptorImpl
implements Interceptor {
    private static final Logger LOGGER = LoggerFactory.getLogger(TxInterceptorImpl.class);
    private TransactionManager tm;
    private TxComponentMetaDataHelper metaDataHelper;

    public int getRank() {
        return 0;
    }

    public void postCallWithException(ComponentMetadata cm, Method m, Throwable ex, Object preCallToken) {
        if (preCallToken instanceof TransactionToken) {
            TransactionToken token = (TransactionToken)preCallToken;
            try {
                Transaction tran = token.getActiveTransaction();
                if (tran != null && (ex instanceof RuntimeException || ex instanceof Error)) {
                    tran.setRollbackOnly();
                }
                token.getTransactionAttribute().finish(this.tm, token);
            }
            catch (Exception e) {
                LOGGER.warn("An exception occurred during transaction clean up, which will be discared in favour of an exception already thrown.", (Throwable)e);
            }
        }
    }

    public void postCallWithReturn(ComponentMetadata cm, Method m, Object returnType, Object preCallToken) throws Exception {
        if (preCallToken == null) {
            return;
        }
        if (preCallToken instanceof TransactionToken) {
            TransactionToken token = (TransactionToken)preCallToken;
            try {
                token.getTransactionAttribute().finish(this.tm, token);
            }
            catch (Exception e) {
                LOGGER.debug("An exception has occured.", (Throwable)e);
                throw new TransactionRollbackException(e);
            }
        }
    }

    public Object preCall(ComponentMetadata cm, Method m, Object ... parameters) throws Throwable {
        String methodName = m.getName();
        String attribute = this.metaDataHelper.getComponentMethodTxAttribute(cm, methodName);
        if (attribute == null) {
            return null;
        }
        TransactionAttribute txAttribute = TransactionAttribute.fromValue(attribute);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Method: " + m + ", has transaction strategy: " + (Object)((Object)txAttribute));
        }
        return txAttribute.begin(this.tm);
    }

    public final void setTransactionManager(TransactionManager manager) {
        this.tm = manager;
    }

    public final void setTxMetaDataHelper(TxComponentMetaDataHelper transactionEnhancer) {
        this.metaDataHelper = transactionEnhancer;
    }
}

