/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.jmx.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeUtils {
    public static Map<String, Class<? extends Object>> primitiveTypes = new HashMap<String, Class<? extends Object>>();
    public static Map<String, Class<? extends Object>> wrapperTypes = new HashMap<String, Class<? extends Object>>();
    public static Map<String, Class<? extends Object>> mathTypes = new HashMap<String, Class<? extends Object>>();
    public static Map<Class<? extends Object>, Class<? extends Object>> primitiveToWrapper = new HashMap<Class<? extends Object>, Class<? extends Object>>();
    public static Map<String, Class<? extends Object>> types = new HashMap<String, Class<? extends Object>>();

    private TypeUtils() {
    }

    public static Map<String, String> fromDictionary(Dictionary<String, String> dictionary) {
        HashMap<String, String> result = new HashMap<String, String>();
        Enumeration<String> keys = dictionary.keys();
        while (keys.hasMoreElements()) {
            String key = keys.nextElement();
            result.put(key, dictionary.get(key));
        }
        return result;
    }

    public static Long[] toLong(long[] array) {
        Long[] toArray = array == null ? new Long[]{} : new Long[array.length];
        for (int i = 0; i < toArray.length; ++i) {
            toArray[i] = array[i];
        }
        return toArray;
    }

    public static long[] toPrimitive(Long[] array) {
        long[] toArray = array == null ? new long[]{} : new long[array.length];
        for (int i = 0; i < toArray.length; ++i) {
            toArray[i] = array[i];
        }
        return toArray;
    }

    public static <T> T fromString(Class<T> type, String value) {
        if (type == null || !types.containsValue(type)) {
            throw new IllegalArgumentException("Cannot convert to type argument : " + type);
        }
        if (value == null || value.length() < 1) {
            throw new IllegalArgumentException("Argument value cannot be null or empty");
        }
        Object result = null;
        try {
            if (type.equals(String.class)) {
                result = value;
            } else if (type.equals(Character.class) || type.equals(Character.TYPE)) {
                result = Character.valueOf(value.charAt(0));
            } else if (wrapperTypes.containsValue(type) || mathTypes.containsValue(type)) {
                Constructor<T> constructor = type.getConstructor(String.class);
                result = constructor.newInstance(value);
            } else if (primitiveToWrapper.containsKey(type)) {
                Class<? extends Object> promotedType = primitiveToWrapper.get(type);
                char[] simpleTypeName = type.getName().toCharArray();
                simpleTypeName[0] = Character.toUpperCase(simpleTypeName[0]);
                String parseMethodName = "parse" + new String(simpleTypeName);
                Method parseMethod = promotedType.getDeclaredMethod(parseMethodName, String.class);
                result = parseMethod.invoke(null, value);
            }
        }
        catch (SecurityException e) {
            throw new IllegalArgumentException("Cannot convert value [" + value + "] to type [" + type + "]", e);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("Cannot convert value [" + value + "] to type [" + type + "]", e);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Cannot convert value [" + value + "] to type [" + type + "]", e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException("Cannot convert value [" + value + "] to type [" + type + "]", e);
        }
        catch (InvocationTargetException e) {
            throw new IllegalArgumentException("Cannot convert value [" + value + "] to type [" + type + "]", e);
        }
        catch (InstantiationException e) {
            throw new IllegalArgumentException("Cannot convert value [" + value + "] to type [" + type + "]", e);
        }
        return (T)result;
    }

    static {
        primitiveTypes.put("float", Float.TYPE);
        primitiveTypes.put("int", Integer.TYPE);
        primitiveTypes.put("long", Long.TYPE);
        primitiveTypes.put("double", Double.TYPE);
        primitiveTypes.put("byte", Byte.TYPE);
        primitiveTypes.put("short", Short.TYPE);
        primitiveTypes.put("char", Character.TYPE);
        primitiveTypes.put("boolean", Boolean.TYPE);
        primitiveToWrapper.put(Float.TYPE, Float.class);
        primitiveToWrapper.put(Integer.TYPE, Integer.class);
        primitiveToWrapper.put(Long.TYPE, Long.class);
        primitiveToWrapper.put(Double.TYPE, Double.class);
        primitiveToWrapper.put(Byte.TYPE, Byte.class);
        primitiveToWrapper.put(Short.TYPE, Short.class);
        primitiveToWrapper.put(Boolean.TYPE, Boolean.class);
        wrapperTypes.put("Integer", Integer.class);
        wrapperTypes.put("Float", Float.class);
        wrapperTypes.put("Long", Long.class);
        wrapperTypes.put("Double", Double.class);
        wrapperTypes.put("Byte", Byte.class);
        wrapperTypes.put("Short", Short.class);
        wrapperTypes.put("Boolean", Boolean.class);
        wrapperTypes.put("Character", Character.class);
        mathTypes.put("BigDecimal", BigDecimal.class);
        mathTypes.put("BigInteger", BigInteger.class);
        types.put("String", String.class);
        types.putAll(primitiveTypes);
        types.putAll(wrapperTypes);
        types.putAll(mathTypes);
    }
}

