/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.shell.config;

import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.apache.felix.gogo.commands.Option;
import org.apache.karaf.shell.config.ConfigCommandSupport;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;

@Command(scope="config", name="delete", description="Delete a configuration.")
public class DeleteCommand
extends ConfigCommandSupport {
    @Argument(index=0, name="pid", description="PID of the configuration", required=true, multiValued=false)
    String pid;
    @Option(name="--force", aliases={}, description="Force the edition of this config, even if another one was under edition", required=false, multiValued=false)
    boolean force;
    @Option(name="-f", aliases={"--use-file"}, description="Configuration lookup using the filename instead of the pid", required=false, multiValued=false)
    boolean useFile;

    protected void doExecute(ConfigurationAdmin admin) throws Exception {
        String oldPid = (String)this.session.get("ConfigCommand.PID");
        if (oldPid != null && oldPid.equals(this.pid) && !this.force) {
            System.err.println("This config is being edited.  Cancel / update first, or use the --force option");
            return;
        }
        if (this.useFile) {
            Configuration configuration = this.findConfigurationByFileName(admin, this.pid);
            if (configuration == null) {
                System.err.println("Could not find configuration with file install property set to: " + this.pid);
                return;
            }
            configuration.delete();
        } else {
            Configuration configuration = admin.getConfiguration(this.pid);
            configuration.delete();
        }
        if (oldPid != null && oldPid.equals(this.pid) && !this.force) {
            this.session.put("ConfigCommand.PID", null);
            this.session.put("ConfigCommand.Props", null);
        }
    }
}

