/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.shell.console.table;

import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.karaf.shell.console.table.Cell;
import org.apache.karaf.shell.console.table.Column;
import org.apache.karaf.shell.console.table.HAlign;
import org.apache.karaf.shell.console.table.Row;
import org.apache.karaf.shell.console.table.StringUtil;
import org.apache.karaf.shell.console.table.Style;
import org.apache.karaf.shell.console.table.StyleCalculator;
import org.apache.karaf.shell.console.table.TableElement;

public class DataTable
extends TableElement {
    private final Appendable target;
    private Style borderStyle = new Style();
    private List<Column> columns = new ArrayList<Column>();
    private List<Row> rows = new ArrayList<Row>();
    private int flushAfter = 10;

    public DataTable(Appendable target) {
        this.target = target;
    }

    public DataTable(PrintStream out, int colCount) {
        this(out);
        for (int i = 0; i < colCount; ++i) {
            this.addColumn(new Column(true));
        }
    }

    public void addColumn(Column column) {
        this.columns.add(column);
    }

    private void printBorder(Row row, String border) {
        if (row.isBorders()) {
            this.append(this.borderStyle.apply(border));
        } else {
            this.append(StringUtil.repeat(" ", border.length()));
        }
    }

    public void flush() {
        this.printRows();
        this.rows.clear();
    }

    private void printRows() {
        for (Row row : this.rows) {
            List<Cell> cells = row.getCells();
            int colIndex = 0;
            int size = cells.size();
            for (int i = 0; i < size; ++i) {
                boolean last;
                Cell cell = cells.get(i);
                int colSpan = cell.getColSpan();
                Column column = this.columns.get(colIndex);
                int colSize = 0;
                boolean first = i == 0;
                boolean bl = last = i + 1 == size;
                if (colSpan > 1) {
                    for (int j = 0; j < colSpan; ++j) {
                        colSize += this.columns.get(colIndex + j).getSize();
                    }
                    colSize += colSpan;
                    colIndex += colSpan;
                } else {
                    colSize = column.getSize();
                    ++colIndex;
                }
                Style style = this.calculateStyle(column, row, cell);
                if (first) {
                    this.printBorder(row, "[");
                } else if (!last) {
                    this.printBorder(row, "][");
                } else {
                    this.printBorder(row, "] ");
                }
                String value = cell.getValue();
                if (value.length() > colSize) {
                    if (column.isMayGrow()) {
                        column.setSize(value.length());
                    } else {
                        value = value.substring(value.length() - 2) + "..";
                    }
                }
                this.append(style.apply(this.calculateAlign(column, cell).position(value, colSize)));
            }
            this.append("\n");
        }
    }

    private HAlign calculateAlign(Column column, Cell cell) {
        if (cell.getAlign() != null) {
            return cell.getAlign();
        }
        return column.getAlign();
    }

    private Style calculateStyle(Column column, Row row, Cell cell) {
        StyleCalculator styleCalculator = column.getStyleCalculator();
        Style dynamic = null;
        if (styleCalculator != null) {
            dynamic = styleCalculator.calculate(cell.getValue());
        }
        if (!cell.getStyle().isClean()) {
            return cell.getStyle();
        }
        if (dynamic != null) {
            return dynamic;
        }
        if (!row.getStyle().isClean()) {
            return row.getStyle();
        }
        if (!column.getStyle().isClean()) {
            return column.getStyle();
        }
        return new Style();
    }

    private void append(String string) {
        try {
            this.target.append(string);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void addRow(Object[] row) {
        this.addRow(new Row(row));
    }

    public void addRow(Row row) {
        this.rows.add(row);
        if (this.rows.size() % this.flushAfter == 0) {
            this.printRows();
            this.rows.clear();
        }
    }

    public void setBorderStyle(Style style) {
        this.borderStyle = style;
    }

    public void setFlushAfter(int flushAfter) {
        this.flushAfter = flushAfter;
    }
}

