/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.timer;

import java.util.Date;
import java.util.Timer;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.Service;
import org.apache.camel.component.timer.TimerComponent;
import org.apache.camel.component.timer.TimerConsumer;
import org.apache.camel.impl.DefaultEndpoint;
import org.springframework.jmx.export.annotation.ManagedAttribute;
import org.springframework.jmx.export.annotation.ManagedResource;

@ManagedResource(description="Managed Timer Endpoint")
public class TimerEndpoint
extends DefaultEndpoint
implements Service {
    private String timerName;
    private Date time;
    private long period = 1000L;
    private long delay;
    private boolean fixedRate;
    private boolean daemon = true;
    private Timer timer;

    public TimerEndpoint() {
    }

    public TimerEndpoint(String fullURI, TimerComponent component, String timerName) {
        super(fullURI, component);
        this.timerName = timerName;
    }

    public TimerEndpoint(String endpointUri, Timer timer) {
        this(endpointUri);
        this.timer = timer;
    }

    public TimerEndpoint(String endpointUri) {
        super(endpointUri);
    }

    public Producer createProducer() throws Exception {
        throw new RuntimeCamelException("Cannot produce to a TimerEndpoint: " + this.getEndpointUri());
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        return new TimerConsumer(this, processor);
    }

    public void start() throws Exception {
    }

    public void stop() throws Exception {
        this.setTimer(null);
    }

    @ManagedAttribute(description="Timer Name")
    public String getTimerName() {
        if (this.timerName == null) {
            this.timerName = this.getEndpointUri();
        }
        return this.timerName;
    }

    @ManagedAttribute(description="Timer Name")
    public void setTimerName(String timerName) {
        this.timerName = timerName;
    }

    @ManagedAttribute(description="Timer Daemon")
    public boolean isDaemon() {
        return this.daemon;
    }

    @ManagedAttribute(description="Timer Daemon")
    public void setDaemon(boolean daemon) {
        this.daemon = daemon;
    }

    @ManagedAttribute(description="Timer Delay")
    public long getDelay() {
        return this.delay;
    }

    @ManagedAttribute(description="Timer Delay")
    public void setDelay(long delay) {
        this.delay = delay;
    }

    @ManagedAttribute(description="Timer FixedRate")
    public boolean isFixedRate() {
        return this.fixedRate;
    }

    @ManagedAttribute(description="Timer FixedRate")
    public void setFixedRate(boolean fixedRate) {
        this.fixedRate = fixedRate;
    }

    @ManagedAttribute(description="Timer Period")
    public long getPeriod() {
        return this.period;
    }

    @ManagedAttribute(description="Timer Period")
    public void setPeriod(long period) {
        this.period = period;
    }

    public Date getTime() {
        return this.time;
    }

    public void setTime(Date time) {
        this.time = time;
    }

    @ManagedAttribute(description="Singleton")
    public boolean isSingleton() {
        return true;
    }

    public synchronized Timer getTimer() {
        if (this.timer == null) {
            TimerComponent tc = (TimerComponent)this.getComponent();
            this.timer = tc.getTimer(this);
        }
        return this.timer;
    }

    public synchronized void setTimer(Timer timer) {
        this.timer = timer;
    }

    @ManagedAttribute(description="Camel id")
    public String getCamelId() {
        return this.getCamelContext().getName();
    }

    @ManagedAttribute(description="Endpoint Uri")
    public String getEndpointUri() {
        return super.getEndpointUri();
    }
}

