/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import java.util.concurrent.atomic.AtomicInteger;
import org.apache.camel.spi.CamelContextNameStrategy;

public class DefaultCamelContextNameStrategy
implements CamelContextNameStrategy {
    private static final AtomicInteger CONTEXT_COUNTER = new AtomicInteger(0);
    private final String prefix;
    private String name;

    public DefaultCamelContextNameStrategy() {
        this("camel");
    }

    public DefaultCamelContextNameStrategy(String prefix) {
        this.prefix = prefix;
        this.name = this.getNextName();
    }

    public String getName() {
        if (this.name == null) {
            this.name = this.getNextName();
        }
        return this.name;
    }

    public String getNextName() {
        return this.prefix + "-" + DefaultCamelContextNameStrategy.getNextCounter();
    }

    public static int getNextCounter() {
        return CONTEXT_COUNTER.incrementAndGet();
    }

    public static void setCounter(int value) {
        CONTEXT_COUNTER.set(value);
    }
}

