/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.Exchange;
import org.apache.camel.LoggingLevel;
import org.apache.camel.Processor;
import org.apache.camel.impl.DefaultExchangeFormatter;
import org.apache.camel.impl.ServiceSupport;
import org.apache.camel.spi.ExchangeFormatter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Logger
extends ServiceSupport
implements Processor {
    private Log log;
    private LoggingLevel level;
    private ExchangeFormatter formatter = DefaultExchangeFormatter.getInstance();

    public Logger() {
        this(LogFactory.getLog(Logger.class));
    }

    public Logger(Log log) {
        this(log, LoggingLevel.INFO);
    }

    public Logger(Log log, LoggingLevel level) {
        this.log = log;
        this.level = level;
    }

    public Logger(String logName) {
        this(LogFactory.getLog((String)logName));
    }

    public Logger(String logName, LoggingLevel level) {
        this(LogFactory.getLog((String)logName), level);
    }

    public Logger(Log log, ExchangeFormatter formatter) {
        this(log);
        this.formatter = formatter;
    }

    public String toString() {
        return "Logger[" + this.log + "]";
    }

    public void process(Exchange exchange) {
        switch (this.level) {
            case DEBUG: {
                if (!this.log.isDebugEnabled()) break;
                this.log.debug(this.logMessage(exchange));
                break;
            }
            case ERROR: {
                if (!this.log.isErrorEnabled()) break;
                this.log.error(this.logMessage(exchange));
                break;
            }
            case FATAL: {
                if (!this.log.isFatalEnabled()) break;
                this.log.fatal(this.logMessage(exchange));
                break;
            }
            case INFO: {
                if (!this.log.isInfoEnabled()) break;
                this.log.info(this.logMessage(exchange));
                break;
            }
            case TRACE: {
                if (!this.log.isTraceEnabled()) break;
                this.log.trace(this.logMessage(exchange));
                break;
            }
            case WARN: {
                if (!this.log.isWarnEnabled()) break;
                this.log.warn(this.logMessage(exchange));
                break;
            }
            case OFF: {
                break;
            }
            default: {
                this.log.error((Object)("Unknown level: " + (Object)((Object)this.level) + " when trying to log exchange: " + this.logMessage(exchange)));
            }
        }
    }

    public void process(Exchange exchange, Throwable exception) {
        switch (this.level) {
            case DEBUG: {
                if (!this.log.isDebugEnabled()) break;
                this.log.debug(this.logMessage(exchange), exception);
                break;
            }
            case ERROR: {
                if (!this.log.isErrorEnabled()) break;
                this.log.error(this.logMessage(exchange), exception);
                break;
            }
            case FATAL: {
                if (!this.log.isFatalEnabled()) break;
                this.log.fatal(this.logMessage(exchange), exception);
                break;
            }
            case INFO: {
                if (!this.log.isInfoEnabled()) break;
                this.log.info(this.logMessage(exchange), exception);
                break;
            }
            case TRACE: {
                if (!this.log.isTraceEnabled()) break;
                this.log.trace(this.logMessage(exchange), exception);
                break;
            }
            case WARN: {
                if (!this.log.isWarnEnabled()) break;
                this.log.warn(this.logMessage(exchange), exception);
                break;
            }
            case OFF: {
                break;
            }
            default: {
                this.log.error((Object)("Unknown level: " + (Object)((Object)this.level) + " when trying to log exchange: " + this.logMessage(exchange)));
            }
        }
    }

    public void process(Exchange exchange, String message) {
        switch (this.level) {
            case DEBUG: {
                if (!this.log.isDebugEnabled()) break;
                this.log.debug(this.logMessage(exchange, message));
                break;
            }
            case ERROR: {
                if (!this.log.isErrorEnabled()) break;
                this.log.error(this.logMessage(exchange, message));
                break;
            }
            case FATAL: {
                if (!this.log.isFatalEnabled()) break;
                this.log.fatal(this.logMessage(exchange, message));
                break;
            }
            case INFO: {
                if (!this.log.isInfoEnabled()) break;
                this.log.info(this.logMessage(exchange, message));
                break;
            }
            case TRACE: {
                if (!this.log.isTraceEnabled()) break;
                this.log.trace(this.logMessage(exchange, message));
                break;
            }
            case WARN: {
                if (!this.log.isWarnEnabled()) break;
                this.log.warn(this.logMessage(exchange, message));
                break;
            }
            case OFF: {
                break;
            }
            default: {
                this.log.error((Object)("Unknown level: " + (Object)((Object)this.level) + " when trying to log exchange: " + this.logMessage(exchange, message)));
            }
        }
    }

    public void log(String message, LoggingLevel loggingLevel) {
        LoggingLevel oldLogLevel = this.getLevel();
        this.setLevel(loggingLevel);
        this.log(message);
        this.setLevel(oldLogLevel);
    }

    public void log(String message) {
        switch (this.level) {
            case DEBUG: {
                if (!this.log.isDebugEnabled()) break;
                this.log.debug((Object)message);
                break;
            }
            case ERROR: {
                if (!this.log.isErrorEnabled()) break;
                this.log.error((Object)message);
                break;
            }
            case FATAL: {
                if (!this.log.isFatalEnabled()) break;
                this.log.fatal((Object)message);
                break;
            }
            case INFO: {
                if (!this.log.isInfoEnabled()) break;
                this.log.info((Object)message);
                break;
            }
            case TRACE: {
                if (!this.log.isTraceEnabled()) break;
                this.log.trace((Object)message);
                break;
            }
            case WARN: {
                if (!this.log.isWarnEnabled()) break;
                this.log.warn((Object)message);
                break;
            }
            case OFF: {
                break;
            }
            default: {
                this.log.error((Object)("Unknown level: " + (Object)((Object)this.level) + " when trying to log exchange: " + message));
            }
        }
    }

    public void log(String message, Throwable exception, LoggingLevel loggingLevel) {
        LoggingLevel oldLogLevel = this.getLevel();
        this.setLevel(loggingLevel);
        this.log(message, exception);
        this.setLevel(oldLogLevel);
    }

    public void log(String message, Throwable exception) {
        switch (this.level) {
            case DEBUG: {
                if (!this.log.isDebugEnabled()) break;
                this.log.debug((Object)message, exception);
                break;
            }
            case ERROR: {
                if (!this.log.isErrorEnabled()) break;
                this.log.error((Object)message, exception);
                break;
            }
            case FATAL: {
                if (!this.log.isFatalEnabled()) break;
                this.log.fatal((Object)message, exception);
                break;
            }
            case INFO: {
                if (!this.log.isInfoEnabled()) break;
                this.log.info((Object)message, exception);
                break;
            }
            case TRACE: {
                if (!this.log.isTraceEnabled()) break;
                this.log.trace((Object)message, exception);
                break;
            }
            case WARN: {
                if (!this.log.isWarnEnabled()) break;
                this.log.warn((Object)message, exception);
                break;
            }
            case OFF: {
                break;
            }
            default: {
                this.log.error((Object)("Unknown level: " + (Object)((Object)this.level) + " when trying to log exchange: " + message), exception);
            }
        }
    }

    protected Object logMessage(Exchange exchange) {
        return this.formatter.format(exchange);
    }

    protected Object logMessage(Exchange exchange, String message) {
        return this.formatter.format(exchange) + message;
    }

    public Log getLog() {
        return this.log;
    }

    public void setLog(Log log) {
        this.log = log;
    }

    public LoggingLevel getLevel() {
        return this.level;
    }

    public void setLevel(LoggingLevel level) {
        this.level = level;
    }

    public void setFormatter(ExchangeFormatter formatter) {
        this.formatter = formatter;
    }

    public void setLogName(String logName) {
        this.log = LogFactory.getLog((String)logName);
    }

    protected void doStart() throws Exception {
    }

    protected void doStop() throws Exception {
    }
}

