/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.concurrent.ExecutorService;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.impl.ProducerCache;
import org.apache.camel.processor.MulticastProcessor;
import org.apache.camel.processor.ProcessorExchangePair;
import org.apache.camel.processor.aggregate.AggregationStrategy;
import org.apache.camel.spi.RouteContext;
import org.apache.camel.util.ExchangeHelper;
import org.apache.camel.util.ServiceHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RecipientListProcessor
extends MulticastProcessor {
    private static final transient Log LOG = LogFactory.getLog(RecipientListProcessor.class);
    private final Iterator<Object> iter;
    private boolean ignoreInvalidEndpoints;
    private ProducerCache producerCache;

    public RecipientListProcessor(CamelContext camelContext, ProducerCache producerCache, Iterator<Object> iter) {
        super(camelContext, null);
        this.producerCache = producerCache;
        this.iter = iter;
    }

    public RecipientListProcessor(CamelContext camelContext, ProducerCache producerCache, Iterator<Object> iter, AggregationStrategy aggregationStrategy) {
        super(camelContext, null, aggregationStrategy);
        this.producerCache = producerCache;
        this.iter = iter;
    }

    public RecipientListProcessor(CamelContext camelContext, ProducerCache producerCache, Iterator<Object> iter, AggregationStrategy aggregationStrategy, boolean parallelProcessing, ExecutorService executorService, boolean streaming, boolean stopOnException, long timeout) {
        super(camelContext, null, aggregationStrategy, parallelProcessing, executorService, streaming, stopOnException, timeout);
        this.producerCache = producerCache;
        this.iter = iter;
    }

    public boolean isIgnoreInvalidEndpoints() {
        return this.ignoreInvalidEndpoints;
    }

    public void setIgnoreInvalidEndpoints(boolean ignoreInvalidEndpoints) {
        this.ignoreInvalidEndpoints = ignoreInvalidEndpoints;
    }

    @Override
    protected Iterable<ProcessorExchangePair> createProcessorExchangePairs(Exchange exchange) throws Exception {
        ArrayList<ProcessorExchangePair> result = new ArrayList<ProcessorExchangePair>();
        int index = 0;
        while (this.iter.hasNext()) {
            Producer producer;
            Endpoint endpoint;
            Object recipient = this.iter.next();
            try {
                endpoint = RecipientListProcessor.resolveEndpoint(exchange, recipient);
                producer = this.producerCache.acquireProducer(endpoint);
            }
            catch (Exception e) {
                if (this.isIgnoreInvalidEndpoints()) {
                    LOG.info((Object)("Endpoint uri is invalid: " + recipient + ". This exception will be ignored."), (Throwable)e);
                    continue;
                }
                throw e;
            }
            result.add(this.createProcessorExchangePair(index++, endpoint, producer, exchange));
        }
        return result;
    }

    protected ProcessorExchangePair createProcessorExchangePair(int index, Endpoint endpoint, Producer producer, Exchange exchange) {
        Processor prepared = producer;
        Exchange copy = ExchangeHelper.createCorrelatedCopy(exchange, false);
        RecipientListProcessor.setToEndpoint(copy, prepared);
        RouteContext routeContext = exchange.getUnitOfWork() != null ? exchange.getUnitOfWork().getRouteContext() : null;
        prepared = this.createErrorHandler(routeContext, prepared);
        return new RecipientProcessorExchangePair(index, this.producerCache, endpoint, producer, prepared, copy);
    }

    protected static Endpoint resolveEndpoint(Exchange exchange, Object recipient) {
        if (recipient instanceof String) {
            recipient = ((String)recipient).trim();
        }
        return ExchangeHelper.resolveEndpoint(exchange, recipient);
    }

    @Override
    protected void doStart() throws Exception {
        super.doStart();
        if (this.producerCache == null) {
            this.producerCache = new ProducerCache(this, this.getCamelContext());
            this.getCamelContext().addService(this.producerCache);
        }
        ServiceHelper.startService(this.producerCache);
    }

    @Override
    protected void doStop() throws Exception {
        ServiceHelper.stopService(this.producerCache);
        super.doStop();
    }

    static final class RecipientProcessorExchangePair
    implements ProcessorExchangePair {
        private final int index;
        private final Endpoint endpoint;
        private final Producer producer;
        private Processor prepared;
        private final Exchange exchange;
        private final ProducerCache producerCache;

        private RecipientProcessorExchangePair(int index, ProducerCache producerCache, Endpoint endpoint, Producer producer, Processor prepared, Exchange exchange) {
            this.index = index;
            this.producerCache = producerCache;
            this.endpoint = endpoint;
            this.producer = producer;
            this.prepared = prepared;
            this.exchange = exchange;
        }

        public int getIndex() {
            return this.index;
        }

        public Exchange getExchange() {
            return this.exchange;
        }

        public Producer getProducer() {
            return this.producer;
        }

        public Processor getProcessor() {
            return this.prepared;
        }

        public void begin() {
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("RecipientProcessorExchangePair #" + this.index + " begin: " + this.exchange));
            }
        }

        public void done() {
            block3: {
                if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)("RecipientProcessorExchangePair #" + this.index + " done: " + this.exchange));
                }
                try {
                    this.producerCache.releaseProducer(this.endpoint, this.producer);
                }
                catch (Exception e) {
                    if (!LOG.isDebugEnabled()) break block3;
                    LOG.debug((Object)("Error releasing producer: " + this.producer + ". This exception will be ignored."), (Throwable)e);
                }
            }
        }
    }
}

