/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.camel.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.apache.camel.Exchange;
import org.apache.camel.spi.HeaderFilterStrategy;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class StrictSerializationHeaderFilterStrategy
implements HeaderFilterStrategy {
    private static final Log LOG = LogFactory.getLog(StrictSerializationHeaderFilterStrategy.class);

    public boolean applyFilterToCamelHeaders(String s, Object o, Exchange exchange) {
        return this.doApplyFilter(s, o);
    }

    public boolean applyFilterToExternalHeaders(String s, Object o, Exchange exchange) {
        return this.doApplyFilter(s, o);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doApplyFilter(String s, Object o) {
        if (o instanceof Serializable) {
            ObjectOutputStream oos = null;
            try {
                oos = new ObjectOutputStream(new ByteArrayOutputStream());
                oos.writeObject(o);
            }
            catch (IOException e) {
                LOG.debug((Object)String.format("%s implements Serializable, but serialization throws IOException: filtering key %s", o, s));
                boolean bl = true;
                return bl;
            }
            finally {
                if (oos != null) {
                    try {
                        oos.close();
                    }
                    catch (IOException e) {}
                }
            }
            return false;
        }
        return true;
    }
}

