/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.camel;

import java.net.URISyntaxException;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import javax.jbi.component.ComponentContext;
import javax.jbi.management.DeploymentException;
import javax.jbi.messaging.ExchangeStatus;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.MessagingException;
import javax.xml.namespace.QName;
import org.apache.camel.AsyncCallback;
import org.apache.camel.AsyncProcessor;
import org.apache.camel.Exchange;
import org.apache.servicemix.camel.JbiBinding;
import org.apache.servicemix.camel.JbiEndpoint;
import org.apache.servicemix.camel.JbiException;
import org.apache.servicemix.common.endpoints.ConsumerEndpoint;
import org.apache.servicemix.common.util.URIResolver;
import org.apache.servicemix.id.IdGenerator;
import org.apache.servicemix.jbi.exception.FaultException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CamelConsumerEndpoint
extends ConsumerEndpoint
implements AsyncProcessor {
    public static final QName SERVICE_NAME = new QName("http://camel.apache.org/schema/jbi", "provider");
    private JbiBinding binding;
    private JbiEndpoint jbiEndpoint;
    private Map<String, ContinuationData> continuations = new ConcurrentHashMap<String, ContinuationData>();

    public CamelConsumerEndpoint(JbiBinding binding, JbiEndpoint jbiEndpoint) {
        this.setService(SERVICE_NAME);
        this.setEndpoint(new IdGenerator().generateId());
        this.binding = binding;
        this.jbiEndpoint = jbiEndpoint;
    }

    public void process(final MessageExchange messageExchange) throws Exception {
        final ContinuationData data = this.continuations.remove(messageExchange.getExchangeId());
        if (data == null) {
            this.logger.error((Object)("Unexpected MessageExchange received: " + messageExchange));
        } else {
            this.binding.runWithCamelContextClassLoader(new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    CamelConsumerEndpoint.this.processReponse(messageExchange, data.exchange);
                    data.callback.done(false);
                    return null;
                }
            });
        }
    }

    public void process(Exchange exchange) throws Exception {
        try {
            MessageExchange messageExchange = this.prepareMessageExchange(exchange);
            this.sendSync(messageExchange);
            this.processReponse(messageExchange, exchange);
        }
        catch (MessagingException e) {
            exchange.setException((Throwable)e);
            throw new JbiException(e);
        }
    }

    public boolean process(Exchange exchange, AsyncCallback asyncCallback) {
        MessageExchange messageExchange = null;
        try {
            messageExchange = this.prepareMessageExchange(exchange);
            this.continuations.put(messageExchange.getExchangeId(), new ContinuationData(exchange, asyncCallback));
            this.send(messageExchange);
            return false;
        }
        catch (Exception e) {
            if (messageExchange != null) {
                this.continuations.remove(messageExchange.getExchangeId());
            }
            exchange.setException((Throwable)e);
            asyncCallback.done(true);
            return true;
        }
    }

    private MessageExchange prepareMessageExchange(Exchange exchange) throws MessagingException, URISyntaxException {
        MessageExchange messageExchange = this.binding.makeJbiMessageExchange(exchange, this.getExchangeFactory(), this.jbiEndpoint.getMep());
        if (this.jbiEndpoint.getOperation() != null) {
            messageExchange.setOperation(this.jbiEndpoint.getOperation());
        }
        URIResolver.configureExchange((MessageExchange)messageExchange, (ComponentContext)this.getContext(), (String)this.jbiEndpoint.getDestinationUri());
        return messageExchange;
    }

    private void processReponse(MessageExchange messageExchange, Exchange exchange) throws MessagingException {
        if (messageExchange.getStatus() == ExchangeStatus.ERROR) {
            exchange.setException((Throwable)messageExchange.getError());
        } else if (messageExchange.getStatus() == ExchangeStatus.ACTIVE) {
            this.binding.copyPropertiesFromJbiToCamel(messageExchange, exchange);
            if (messageExchange.getFault() != null) {
                this.binding.copyFromJbiToCamel(messageExchange.getMessage("fault"), exchange.getOut());
                exchange.getOut().setBody((Object)new FaultException("Fault occured for " + exchange.getPattern() + " exchange", messageExchange, messageExchange.getFault()));
                exchange.getOut().setFault(true);
            } else if (messageExchange.getMessage("out") != null) {
                this.binding.copyFromJbiToCamel(messageExchange.getMessage("out"), exchange.getOut());
            }
            this.done(messageExchange);
        }
    }

    public void validate() throws DeploymentException {
    }

    protected Map<String, ContinuationData> getContinuationData() {
        return Collections.unmodifiableMap(this.continuations);
    }

    protected JbiEndpoint getJbiEndpoint() {
        return this.jbiEndpoint;
    }

    private static final class ContinuationData {
        private final Exchange exchange;
        private final AsyncCallback callback;

        private ContinuationData(Exchange exchange, AsyncCallback callback) {
            this.exchange = exchange;
            this.callback = callback;
        }
    }
}

