/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.camel;

import java.util.concurrent.Callable;
import javax.jbi.messaging.ExchangeStatus;
import javax.jbi.messaging.Fault;
import javax.jbi.messaging.InOnly;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.MessagingException;
import javax.jbi.messaging.NormalizedMessage;
import javax.jbi.messaging.RobustInOnly;
import javax.xml.namespace.QName;
import org.apache.camel.AsyncCallback;
import org.apache.camel.AsyncProcessor;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.spi.Synchronization;
import org.apache.servicemix.camel.JbiBinding;
import org.apache.servicemix.common.ServiceUnit;
import org.apache.servicemix.common.endpoints.ProviderEndpoint;
import org.apache.servicemix.jbi.exception.FaultException;

public class CamelProviderEndpoint
extends ProviderEndpoint
implements Synchronization {
    public static final QName SERVICE_NAME = new QName("http://camel.apache.org/schema/jbi", "provider");
    private final JbiBinding binding;
    private Endpoint camelEndpoint;
    private AsyncProcessor camelProcessor;

    public CamelProviderEndpoint(ServiceUnit serviceUnit, QName service, String endpoint, JbiBinding binding, AsyncProcessor camelProcessor) {
        super(serviceUnit, service, endpoint);
        this.camelProcessor = camelProcessor;
        this.binding = binding;
    }

    public CamelProviderEndpoint(ServiceUnit serviceUnit, Endpoint camelEndpoint, JbiBinding binding, AsyncProcessor camelProcessor) {
        this(serviceUnit, SERVICE_NAME, camelEndpoint.getEndpointUri(), binding, camelProcessor);
    }

    public void setCamelEndpoint(Endpoint camelEndpoint) {
        this.camelEndpoint = camelEndpoint;
    }

    public void process(MessageExchange exchange) throws Exception {
        if (exchange.getRole() == MessageExchange.Role.PROVIDER) {
            if (exchange.getStatus() == ExchangeStatus.DONE) {
                return;
            }
            if (exchange.getStatus() == ExchangeStatus.ERROR) {
                return;
            }
        } else {
            throw new IllegalStateException("Unsupported role: " + exchange.getRole());
        }
        this.handleActiveProviderExchange(exchange);
    }

    protected void handleActiveProviderExchange(MessageExchange exchange) throws Exception {
        if (exchange.getFault() != null) {
            this.done(exchange);
        } else if (exchange.getMessage("in") != null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Received exchange: " + exchange));
            }
            final Exchange camelExchange = this.binding.createExchange(exchange);
            camelExchange.setFromEndpoint(this.camelEndpoint);
            camelExchange.addOnCompletion((Synchronization)this);
            this.binding.runWithCamelContextClassLoader(new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    CamelProviderEndpoint.this.camelProcessor.process(camelExchange, new AsyncCallback(){

                        public void done(boolean doneSync) {
                        }
                    });
                    return null;
                }
            });
        } else {
            throw new IllegalStateException("Provider exchange is ACTIVE, but no in or fault is provided");
        }
    }

    private boolean isFaultCapable(MessageExchange exchange) {
        return !(exchange instanceof InOnly);
    }

    private void doSend(MessageExchange exchange) throws MessagingException {
        boolean txSync;
        boolean bl = txSync = exchange.isTransacted() && Boolean.TRUE.equals(exchange.getProperty("javax.jbi.messaging.sendSync"));
        if (txSync && ExchangeStatus.ACTIVE.equals(exchange.getStatus())) {
            this.sendSync(exchange);
        } else {
            this.send(exchange);
        }
    }

    public void onComplete(Exchange exchange) {
        MessageExchange me = JbiBinding.getMessageExchange(exchange);
        try {
            this.binding.copyFromCamelToJbi(exchange, me);
            if (me instanceof InOnly || me instanceof RobustInOnly) {
                this.done(me);
            } else {
                this.doSend(me);
            }
        }
        catch (MessagingException e) {
            this.logger.warn((Object)("Unable to send JBI MessageExchange after successful Camel route invocation: " + me), (Throwable)e);
        }
    }

    public void onFailure(Exchange exchange) {
        MessageExchange me = JbiBinding.getMessageExchange(exchange);
        try {
            if (exchange.hasOut() && exchange.getOut().isFault()) {
                Fault fault = me.createFault();
                this.binding.copyFromCamelToJbi(exchange.getOut(), (NormalizedMessage)fault);
                if (this.isFaultCapable(me)) {
                    me.setFault(fault);
                    this.doSend(me);
                } else {
                    this.fail(me, (Exception)new FaultException("Fault occured for " + exchange.getPattern() + " exchange", me, fault));
                }
            } else {
                this.fail(me, this.binding.extractException(exchange));
            }
        }
        catch (MessagingException e) {
            this.logger.warn((Object)("Unable to send JBI MessageExchange after successful Camel route invocation: " + me), (Throwable)e);
        }
    }
}

