/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.vm;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.component.seda.SedaComponent;
import org.apache.camel.component.seda.SedaEndpoint;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VmComponent
extends SedaComponent {
    protected static final Map<String, BlockingQueue> QUEUES = new HashMap<String, BlockingQueue>();
    private static final AtomicInteger START_COUNTER = new AtomicInteger();

    @Override
    protected Endpoint createEndpoint(String uri, String remaining, Map parameters) throws Exception {
        BlockingQueue<Exchange> blockingQueue = this.getBlockingQueue(uri, parameters);
        return new SedaEndpoint(uri, this, blockingQueue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected BlockingQueue<Exchange> getBlockingQueue(String uri, Map parameters) {
        Map<String, BlockingQueue> map = QUEUES;
        synchronized (map) {
            BlockingQueue<Exchange> answer = QUEUES.get(uri);
            if (answer == null) {
                answer = this.createQueue(uri, parameters);
                QUEUES.put(uri, answer);
            }
            return answer;
        }
    }

    @Override
    protected void doStart() throws Exception {
        super.doStart();
        START_COUNTER.incrementAndGet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doStop() throws Exception {
        super.doStop();
        if (START_COUNTER.decrementAndGet() == 0) {
            Map<String, BlockingQueue> map = QUEUES;
            synchronized (map) {
                for (BlockingQueue q : QUEUES.values()) {
                    q.clear();
                }
                QUEUES.clear();
            }
        }
    }
}

