/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import javax.naming.Context;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.ResolveEndpointFailedException;
import org.apache.camel.Route;
import org.apache.camel.Routes;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.Service;
import org.apache.camel.TypeConverter;
import org.apache.camel.builder.ErrorHandlerBuilder;
import org.apache.camel.impl.DefaultComponentResolver;
import org.apache.camel.impl.DefaultExchangeConverter;
import org.apache.camel.impl.DefaultLanguageResolver;
import org.apache.camel.impl.DefaultLifecycleStrategy;
import org.apache.camel.impl.DefaultProducerTemplate;
import org.apache.camel.impl.JndiRegistry;
import org.apache.camel.impl.ProcessorEndpoint;
import org.apache.camel.impl.ServiceSupport;
import org.apache.camel.impl.converter.DefaultTypeConverter;
import org.apache.camel.management.InstrumentationLifecycleStrategy;
import org.apache.camel.model.RouteType;
import org.apache.camel.model.dataformat.DataFormatType;
import org.apache.camel.processor.interceptor.Delayer;
import org.apache.camel.processor.interceptor.TraceFormatter;
import org.apache.camel.processor.interceptor.Tracer;
import org.apache.camel.spi.ComponentResolver;
import org.apache.camel.spi.ExchangeConverter;
import org.apache.camel.spi.Injector;
import org.apache.camel.spi.InterceptStrategy;
import org.apache.camel.spi.Language;
import org.apache.camel.spi.LanguageResolver;
import org.apache.camel.spi.LifecycleStrategy;
import org.apache.camel.spi.Registry;
import org.apache.camel.util.FactoryFinder;
import org.apache.camel.util.LRUCache;
import org.apache.camel.util.NoFactoryAvailableException;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.ReflectionInjector;
import org.apache.camel.util.ServiceHelper;
import org.apache.camel.util.SystemHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultCamelContext
extends ServiceSupport
implements CamelContext,
Service {
    private static final transient Log LOG = LogFactory.getLog(DefaultCamelContext.class);
    private static final String NAME_PREFIX = "camel-";
    private static int nameSuffix;
    private boolean routeDefinitionInitiated;
    private String name;
    private final Map<String, Endpoint> endpoints = new LRUCache<String, Endpoint>(1000);
    private final Map<String, Component> components = new HashMap<String, Component>();
    private List<Route> routes;
    private List<Service> servicesToClose = new ArrayList<Service>();
    private TypeConverter typeConverter;
    private ExchangeConverter exchangeConverter;
    private Injector injector;
    private ComponentResolver componentResolver;
    private boolean autoCreateComponents = true;
    private LanguageResolver languageResolver = new DefaultLanguageResolver();
    private Registry registry;
    private LifecycleStrategy lifecycleStrategy;
    private List<RouteType> routeDefinitions = new ArrayList<RouteType>();
    private List<InterceptStrategy> interceptStrategies = new ArrayList<InterceptStrategy>();
    private Boolean trace;
    private Long delay;
    private ErrorHandlerBuilder errorHandlerBuilder;
    private Map<String, DataFormatType> dataFormats = new HashMap<String, DataFormatType>();
    private Map<String, String> properties = new HashMap<String, String>();
    private Class<? extends FactoryFinder> factoryFinderClass = FactoryFinder.class;

    public DefaultCamelContext() {
        this.name = NAME_PREFIX + ++nameSuffix;
        if (Boolean.getBoolean("org.apache.camel.jmx.disabled")) {
            LOG.info((Object)"JMX is disabled. Using DefaultLifecycleStrategy.");
            this.lifecycleStrategy = new DefaultLifecycleStrategy();
        } else {
            try {
                LOG.info((Object)"JMX enabled. Using InstrumentationLifecycleStrategy.");
                this.lifecycleStrategy = new InstrumentationLifecycleStrategy();
            }
            catch (NoClassDefFoundError e) {
                LOG.warn((Object)("Could not find needed classes for JMX lifecycle strategy. Needed class is in spring-context.jar using Spring 2.5 or newer ( spring-jmx.jar using Spring 2.0.x). NoClassDefFoundError: " + e.getMessage()));
            }
            catch (Exception e) {
                LOG.warn((Object)("Could not create JMX lifecycle strategy, caused by: " + e.getMessage()));
            }
            if (this.lifecycleStrategy == null) {
                LOG.warn((Object)"Not possible to use JMX lifecycle strategy. Using DefaultLifecycleStrategy instead.");
                this.lifecycleStrategy = new DefaultLifecycleStrategy();
            }
        }
    }

    public DefaultCamelContext(Context jndiContext) {
        this();
        this.setJndiContext(jndiContext);
    }

    public DefaultCamelContext(Registry registry) {
        this();
        this.registry = registry;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addComponent(String componentName, Component component) {
        if (component == null) {
            throw new IllegalArgumentException("Component cannot be null");
        }
        Map<String, Component> map = this.components;
        synchronized (map) {
            if (this.components.containsKey(componentName)) {
                throw new IllegalArgumentException("Component previously added: " + componentName);
            }
            component.setCamelContext(this);
            this.components.put(componentName, component);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Component getComponent(String name) {
        Map<String, Component> map = this.components;
        synchronized (map) {
            Component component = this.components.get(name);
            if (component == null && this.autoCreateComponents) {
                try {
                    component = this.getComponentResolver().resolveComponent(name, this);
                    if (component != null) {
                        this.addComponent(name, component);
                        if (this.isStarted() || this.isStarting()) {
                            ServiceHelper.startServices(component);
                        }
                    }
                }
                catch (Exception e) {
                    throw new RuntimeCamelException("Could not auto create component: " + name, e);
                }
            }
            return component;
        }
    }

    @Override
    public <T extends Component> T getComponent(String name, Class<T> componentType) {
        Component component = this.getComponent(name);
        if (componentType.isInstance(component)) {
            return (T)((Component)componentType.cast(component));
        }
        throw new IllegalArgumentException("The component is not of type: " + componentType + " but is: " + component);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Component removeComponent(String componentName) {
        Map<String, Component> map = this.components;
        synchronized (map) {
            return this.components.remove(componentName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Component getOrCreateComponent(String componentName, Callable<Component> factory) {
        Map<String, Component> map = this.components;
        synchronized (map) {
            Component component = this.components.get(componentName);
            if (component == null) {
                try {
                    component = factory.call();
                    if (component == null) {
                        throw new RuntimeCamelException("Factory failed to create the " + componentName + " component, it returned null.");
                    }
                    this.components.put(componentName, component);
                    component.setCamelContext(this);
                }
                catch (Exception e) {
                    throw new RuntimeCamelException("Factory failed to create the " + componentName + " component", e);
                }
            }
            return component;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<Endpoint> getEndpoints() {
        Map<String, Endpoint> map = this.endpoints;
        synchronized (map) {
            return new ArrayList<Endpoint>(this.endpoints.values());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, Endpoint> getEndpointMap() {
        Map<String, Endpoint> map = this.endpoints;
        synchronized (map) {
            return new HashMap<String, Endpoint>(this.endpoints);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<Endpoint> getEndpoints(String uri) {
        ArrayList<Endpoint> coll;
        ArrayList<Endpoint> answer = new ArrayList<Endpoint>();
        Map<String, Endpoint> map = this.endpoints;
        synchronized (map) {
            Endpoint ep = this.endpoints.get(uri);
            if (ep != null) {
                answer.add(ep);
                return answer;
            }
            coll = new ArrayList<Endpoint>(this.endpoints.values());
        }
        for (Endpoint ep : coll) {
            if (ep.isSingleton() || !uri.equals(ep.getEndpointUri())) continue;
            answer.add(ep);
        }
        return answer;
    }

    @Override
    public Collection<Endpoint> getSingletonEndpoints() {
        ArrayList<Endpoint> answer = new ArrayList<Endpoint>();
        Collection<Endpoint> coll = this.getEndpoints();
        for (Endpoint ep : coll) {
            if (!ep.isSingleton()) continue;
            answer.add(ep);
        }
        return answer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Endpoint addEndpoint(String uri, Endpoint endpoint) throws Exception {
        Endpoint oldEndpoint;
        Map<String, Endpoint> map = this.endpoints;
        synchronized (map) {
            ServiceHelper.startServices(endpoint);
            oldEndpoint = this.endpoints.remove(uri);
            this.endpoints.put(this.getEndpointKey(uri, endpoint), endpoint);
            if (oldEndpoint != null) {
                ServiceHelper.stopServices(oldEndpoint);
            }
        }
        return oldEndpoint;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<Endpoint> removeEndpoints(String uri) throws Exception {
        ArrayList<Endpoint> answer = new ArrayList<Endpoint>();
        Map<String, Endpoint> map = this.endpoints;
        synchronized (map) {
            Endpoint oldEndpoint = this.endpoints.remove(uri);
            if (oldEndpoint != null) {
                answer.add(oldEndpoint);
                ServiceHelper.stopServices(oldEndpoint);
            } else {
                for (Map.Entry<String, Endpoint> entry : this.endpoints.entrySet()) {
                    oldEndpoint = entry.getValue();
                    if (oldEndpoint.isSingleton() || !uri.equals(oldEndpoint.getEndpointUri())) continue;
                    answer.add(oldEndpoint);
                    ServiceHelper.stopServices(oldEndpoint);
                    this.endpoints.remove(entry.getKey());
                }
            }
        }
        return answer;
    }

    @Override
    public Endpoint addSingletonEndpoint(String uri, Endpoint endpoint) throws Exception {
        return this.addEndpoint(uri, endpoint);
    }

    @Override
    public Endpoint removeSingletonEndpoint(String uri) throws Exception {
        Collection<Endpoint> answer = this.removeEndpoints(uri);
        return (Endpoint)(answer.size() > 0 ? answer.toArray()[0] : null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Endpoint getEndpoint(String uri) {
        Endpoint answer;
        Map<String, Endpoint> map = this.endpoints;
        synchronized (map) {
            answer = this.endpoints.get(uri);
            if (answer == null) {
                try {
                    String scheme;
                    Component component;
                    String[] splitURI = ObjectHelper.splitOnCharacter(uri, ":", 2);
                    if (splitURI[1] != null && (component = this.getComponent(scheme = splitURI[0])) != null && (answer = component.createEndpoint(uri)) != null && LOG.isDebugEnabled()) {
                        LOG.debug((Object)(uri + " converted to endpoint: " + answer + " by component: " + component));
                    }
                    if (answer == null) {
                        answer = this.createEndpoint(uri);
                    }
                    if (answer != null) {
                        this.addService(answer);
                        this.endpoints.put(this.getEndpointKey(uri, answer), answer);
                        this.lifecycleStrategy.onEndpointAdd(answer);
                    }
                }
                catch (Exception e) {
                    LOG.debug((Object)("Failed to resolve endpoint " + uri + ". Reason: " + e), (Throwable)e);
                    throw new ResolveEndpointFailedException(uri, e);
                }
            }
        }
        return answer;
    }

    @Override
    public <T extends Endpoint> T getEndpoint(String name, Class<T> endpointType) {
        Endpoint endpoint = this.getEndpoint(name);
        if (endpointType.isInstance(endpoint)) {
            return (T)((Endpoint)endpointType.cast(endpoint));
        }
        throw new IllegalArgumentException("The endpoint is not of type: " + endpointType + " but is: " + endpoint);
    }

    @Override
    public List<Route> getRoutes() {
        if (this.routes == null) {
            this.routes = new ArrayList<Route>();
        }
        return this.routes;
    }

    @Override
    public void setRoutes(List<Route> routes) {
        this.routes = routes;
        throw new UnsupportedOperationException("overriding existing routes is not supported yet, use addRoutes instead");
    }

    @Override
    public void addRoutes(Collection<Route> routes) throws Exception {
        if (this.routes == null) {
            this.routes = new ArrayList<Route>();
        }
        if (routes != null) {
            this.routes.addAll(routes);
            this.lifecycleStrategy.onRoutesAdd(routes);
            if (this.shouldStartRoutes()) {
                this.startRoutes(routes);
            }
        }
    }

    @Override
    public void addRoutes(Routes builder) throws Exception {
        builder.setContext(this);
        List<Route> routeList = builder.getRouteList();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Adding routes from: " + builder + " routes: " + routeList));
        }
        this.addRoutes(routeList);
    }

    @Override
    public void addRouteDefinitions(Collection<RouteType> routeDefinitions) throws Exception {
        this.routeDefinitions.addAll(routeDefinitions);
        if (this.shouldStartRoutes()) {
            this.startRouteDefinitions(routeDefinitions);
        }
    }

    public void addService(Object object) throws Exception {
        if (object instanceof Service) {
            Service service = (Service)object;
            this.getLifecycleStrategy().onServiceAdd(this, service);
            service.start();
            this.servicesToClose.add(service);
        }
    }

    @Override
    public Language resolveLanguage(String language) {
        return this.getLanguageResolver().resolveLanguage(language, this);
    }

    @Override
    public ExchangeConverter getExchangeConverter() {
        if (this.exchangeConverter == null) {
            this.exchangeConverter = this.createExchangeConverter();
        }
        return this.exchangeConverter;
    }

    public void setExchangeConverter(ExchangeConverter exchangeConverter) {
        this.exchangeConverter = exchangeConverter;
    }

    @Override
    public TypeConverter getTypeConverter() {
        if (this.typeConverter == null) {
            this.typeConverter = this.createTypeConverter();
        }
        return this.typeConverter;
    }

    public void setTypeConverter(TypeConverter typeConverter) {
        this.typeConverter = typeConverter;
    }

    @Override
    public Injector getInjector() {
        if (this.injector == null) {
            this.injector = this.createInjector();
        }
        return this.injector;
    }

    public void setInjector(Injector injector) {
        this.injector = injector;
    }

    public ComponentResolver getComponentResolver() {
        if (this.componentResolver == null) {
            this.componentResolver = this.createComponentResolver();
        }
        return this.componentResolver;
    }

    public void setComponentResolver(ComponentResolver componentResolver) {
        this.componentResolver = componentResolver;
    }

    public LanguageResolver getLanguageResolver() {
        return this.languageResolver;
    }

    public void setLanguageResolver(LanguageResolver languageResolver) {
        this.languageResolver = languageResolver;
    }

    public boolean isAutoCreateComponents() {
        return this.autoCreateComponents;
    }

    public void setAutoCreateComponents(boolean autoCreateComponents) {
        this.autoCreateComponents = autoCreateComponents;
    }

    @Override
    public Registry getRegistry() {
        if (this.registry == null) {
            this.registry = this.createRegistry();
        }
        return this.registry;
    }

    public void setJndiContext(Context jndiContext) {
        this.setRegistry(new JndiRegistry(jndiContext));
    }

    public void setRegistry(Registry registry) {
        this.registry = registry;
    }

    @Override
    public LifecycleStrategy getLifecycleStrategy() {
        return this.lifecycleStrategy;
    }

    public void setLifecycleStrategy(LifecycleStrategy lifecycleStrategy) {
        this.lifecycleStrategy = lifecycleStrategy;
    }

    @Override
    public List<RouteType> getRouteDefinitions() {
        return this.routeDefinitions;
    }

    public List<InterceptStrategy> getInterceptStrategies() {
        return this.interceptStrategies;
    }

    public void setInterceptStrategies(List<InterceptStrategy> interceptStrategies) {
        this.interceptStrategies = interceptStrategies;
    }

    @Override
    public void addInterceptStrategy(InterceptStrategy interceptStrategy) {
        this.getInterceptStrategies().add(interceptStrategy);
    }

    public boolean getTrace() {
        Boolean value = this.getTracing();
        if (value != null) {
            return value;
        }
        return SystemHelper.isSystemProperty("camel.trace");
    }

    public Boolean getTracing() {
        return this.trace;
    }

    public void setTrace(Boolean trace) {
        this.trace = trace;
    }

    public long getDelay() {
        Long value = this.getDelaying();
        if (value != null) {
            return value;
        }
        String prop = SystemHelper.getSystemProperty("camel.delay");
        return prop != null ? Long.getLong(prop) : 0L;
    }

    public Long getDelaying() {
        return this.delay;
    }

    public void setDelay(Long delay) {
        this.delay = delay;
    }

    @Override
    public <E extends Exchange> ProducerTemplate<E> createProducerTemplate() {
        return new DefaultProducerTemplate(this);
    }

    @Override
    public ErrorHandlerBuilder getErrorHandlerBuilder() {
        return this.errorHandlerBuilder;
    }

    @Override
    public void setErrorHandlerBuilder(ErrorHandlerBuilder errorHandlerBuilder) {
        this.errorHandlerBuilder = errorHandlerBuilder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() throws Exception {
        super.start();
        DefaultCamelContext defaultCamelContext = this;
        synchronized (defaultCamelContext) {
            this.startRoutes(this.routes);
        }
        LOG.info((Object)("Apache Camel " + this.getVersion() + " (CamelContext:" + this.getName() + ") started"));
    }

    @Override
    protected void doStart() throws Exception {
        block8: {
            LOG.info((Object)("Apache Camel " + this.getVersion() + " (CamelContext:" + this.getName() + ") is starting"));
            if (this.getTrace() && Tracer.getTracer(this) == null) {
                Tracer tracer = new Tracer();
                TraceFormatter formatter = this.getRegistry().lookup("traceFormatter", TraceFormatter.class);
                if (formatter != null) {
                    tracer.setFormatter(formatter);
                }
                this.addInterceptStrategy(tracer);
            }
            if (this.getDelay() > 0L && Delayer.getDelayer(this) == null) {
                this.addInterceptStrategy(new Delayer(this.getDelay()));
            }
            try {
                this.lifecycleStrategy.onContextStart(this);
            }
            catch (Exception e) {
                LOG.warn((Object)("Cannot start lifecycleStrategy: " + this.lifecycleStrategy + ". Cause: " + e.getMessage()));
                if (!(this.lifecycleStrategy instanceof InstrumentationLifecycleStrategy)) break block8;
                LOG.warn((Object)"Will fallback to use default (non JMX) lifecycle strategy");
                this.lifecycleStrategy = new DefaultLifecycleStrategy();
                this.lifecycleStrategy.onContextStart(this);
            }
        }
        this.forceLazyInitialization();
        if (this.components != null) {
            for (Component component : this.components.values()) {
                ServiceHelper.startServices(component);
            }
        }
        if (!this.routeDefinitionInitiated) {
            this.startRouteDefinitions(this.routeDefinitions);
            this.routeDefinitionInitiated = true;
        }
    }

    protected void startRouteDefinitions(Collection<RouteType> list) throws Exception {
        if (list != null) {
            ArrayList<Route> routes = new ArrayList<Route>();
            for (RouteType route : list) {
                route.addRoutes(this, routes);
            }
            this.addRoutes(routes);
        }
    }

    @Override
    protected void doStop() throws Exception {
        ServiceHelper.stopServices(this.servicesToClose);
        if (this.components != null) {
            for (Component component : this.components.values()) {
                ServiceHelper.stopServices(component);
            }
        }
        this.servicesToClose.clear();
    }

    protected void startRoutes(Collection<Route> routeList) throws Exception {
        if (routeList != null) {
            for (Route route : routeList) {
                List<Service> services = route.getServicesForRoute();
                for (Service service : services) {
                    this.addService(service);
                }
            }
        }
    }

    protected void forceLazyInitialization() {
        this.getExchangeConverter();
        this.getInjector();
        this.getLanguageResolver();
        this.getTypeConverter();
    }

    protected ExchangeConverter createExchangeConverter() {
        return new DefaultExchangeConverter();
    }

    protected TypeConverter createTypeConverter() {
        return new DefaultTypeConverter(this.getInjector());
    }

    protected Injector createInjector() {
        FactoryFinder finder = this.createFactoryFinder();
        try {
            return (Injector)finder.newInstance("Injector");
        }
        catch (NoFactoryAvailableException e) {
            return new ReflectionInjector();
        }
        catch (IllegalAccessException e) {
            throw new RuntimeCamelException(e);
        }
        catch (InstantiationException e) {
            throw new RuntimeCamelException(e);
        }
        catch (IOException e) {
            throw new RuntimeCamelException(e);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeCamelException(e);
        }
    }

    protected ComponentResolver createComponentResolver() {
        return new DefaultComponentResolver();
    }

    protected Registry createRegistry() {
        return new JndiRegistry();
    }

    protected Endpoint createEndpoint(String uri) {
        Object value = this.getRegistry().lookup(uri);
        if (value instanceof Endpoint) {
            return (Endpoint)value;
        }
        if (value instanceof Processor) {
            return new ProcessorEndpoint(uri, this, (Processor)value);
        }
        if (value != null) {
            return this.convertBeanToEndpoint(uri, value);
        }
        return null;
    }

    protected Endpoint convertBeanToEndpoint(String uri, Object bean) {
        throw new IllegalArgumentException("uri: " + uri + " bean: " + bean + " could not be converted to an Endpoint");
    }

    protected boolean shouldStartRoutes() {
        return this.isStarted() && !this.isStarting();
    }

    @Override
    public void setDataFormats(Map<String, DataFormatType> dataFormats) {
        this.dataFormats = dataFormats;
    }

    @Override
    public Map<String, DataFormatType> getDataFormats() {
        return this.dataFormats;
    }

    public void setFactoryFinderClass(Class<? extends FactoryFinder> finderClass) {
        this.factoryFinderClass = finderClass;
    }

    @Override
    public Map<String, String> getProperties() {
        return this.properties;
    }

    @Override
    public void setProperties(Map<String, String> properties) {
        this.properties = properties;
    }

    @Override
    public FactoryFinder createFactoryFinder() {
        try {
            return this.factoryFinderClass.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeCamelException(e);
        }
    }

    @Override
    public FactoryFinder createFactoryFinder(String path) {
        try {
            Constructor<? extends FactoryFinder> constructor = this.factoryFinderClass.getConstructor(String.class);
            return constructor.newInstance(path);
        }
        catch (Exception e) {
            throw new RuntimeCamelException(e);
        }
    }

    protected synchronized String getEndpointKey(String uri, Endpoint endpoint) {
        if (endpoint.isSingleton()) {
            return uri;
        }
        int counter = 0;
        while (true) {
            String key;
            String string = key = counter > 0 ? uri + ":" + counter : uri;
            if (!this.endpoints.containsKey(key)) {
                return key;
            }
            ++counter;
        }
    }
}

