/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.ExchangeProperty;
import org.apache.camel.Message;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.impl.DefaultMessage;
import org.apache.camel.impl.MessageSupport;
import org.apache.camel.spi.UnitOfWork;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.UuidGenerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultExchange
implements Exchange {
    private static final UuidGenerator DEFAULT_ID_GENERATOR = new UuidGenerator();
    protected final CamelContext context;
    private Map<String, Object> properties;
    private Message in;
    private Message out;
    private Message fault;
    private Throwable exception;
    private String exchangeId;
    private UnitOfWork unitOfWork;
    private ExchangePattern pattern;

    public DefaultExchange(CamelContext context) {
        this(context, ExchangePattern.InOnly);
    }

    public DefaultExchange(CamelContext context, ExchangePattern pattern) {
        this.context = context;
        this.pattern = pattern;
    }

    public DefaultExchange(DefaultExchange parent) {
        this(parent.getContext(), parent.getPattern());
        this.unitOfWork = parent.getUnitOfWork();
    }

    public String toString() {
        return "Exchange[" + this.in + "]";
    }

    @Override
    public Exchange copy() {
        Exchange exchange = this.newInstance();
        exchange.copyFrom(this);
        return exchange;
    }

    @Override
    public void copyFrom(Exchange exchange) {
        Message copyFault;
        if (exchange == this) {
            return;
        }
        this.setProperties(DefaultExchange.safeCopy(exchange.getProperties()));
        DefaultExchange.safeCopy(this.getIn(), exchange, exchange.getIn());
        Message copyOut = exchange.getOut(false);
        if (copyOut != null) {
            DefaultExchange.safeCopy(this.getOut(true), exchange, copyOut);
        }
        if ((copyFault = exchange.getFault(false)) != null) {
            DefaultExchange.safeCopy(this.getFault(true), exchange, copyFault);
        }
        this.setException(exchange.getException());
        this.unitOfWork = exchange.getUnitOfWork();
        this.pattern = exchange.getPattern();
    }

    private static void safeCopy(Message message, Exchange exchange, Message that) {
        if (message != null) {
            message.copyFrom(that);
        }
    }

    private static Map<String, Object> safeCopy(Map<String, Object> properties) {
        if (properties == null) {
            return null;
        }
        return new ConcurrentHashMap<String, Object>(properties);
    }

    private static Message safeCopy(Exchange exchange, Message message) {
        if (message == null) {
            return null;
        }
        Message answer = message.copy();
        if (answer instanceof MessageSupport) {
            MessageSupport messageSupport = (MessageSupport)answer;
            messageSupport.setExchange(exchange);
        }
        return answer;
    }

    @Override
    public Exchange newInstance() {
        return new DefaultExchange(this);
    }

    @Override
    public CamelContext getContext() {
        return this.context;
    }

    @Override
    public Object getProperty(String name) {
        if (this.properties != null) {
            return this.properties.get(name);
        }
        return null;
    }

    @Override
    public <T> T getProperty(String name, Class<T> type) {
        Object value = this.getProperty(name);
        ExchangeProperty<?> property = ExchangeProperty.getByName(name);
        if (property != null) {
            this.validateExchangePropertyIsExpectedType(property, type, value);
        }
        return this.getContext().getTypeConverter().convertTo(type, this, value);
    }

    @Override
    public void setProperty(String name, Object value) {
        ExchangeProperty<?> property = ExchangeProperty.getByName(name);
        if (property != null) {
            Class<?> type = value.getClass();
            this.validateExchangePropertyIsExpectedType(property, type, value);
        }
        if (value != null) {
            this.getProperties().put(name, value);
        } else if (name != null) {
            this.getProperties().remove(name);
        }
    }

    private <T> void validateExchangePropertyIsExpectedType(ExchangeProperty<?> property, Class<T> type, Object value) {
        if (value != null && property != null && !property.type().isAssignableFrom(type)) {
            throw new RuntimeCamelException("Type cast exception while getting an Exchange Property value '" + value.toString() + "' on Exchange " + this + " for a well known Exchange Property with these traits: " + property);
        }
    }

    @Override
    public Object removeProperty(String name) {
        return this.getProperties().remove(name);
    }

    @Override
    public Map<String, Object> getProperties() {
        if (this.properties == null) {
            this.properties = new ConcurrentHashMap<String, Object>();
        }
        return this.properties;
    }

    public void setProperties(Map<String, Object> properties) {
        this.properties = properties;
    }

    @Override
    public Message getIn() {
        if (this.in == null) {
            this.in = this.createInMessage();
            this.configureMessage(this.in);
        }
        return this.in;
    }

    @Override
    public void setIn(Message in) {
        this.in = in;
        this.configureMessage(in);
    }

    @Override
    public Message getOut() {
        return this.getOut(true);
    }

    @Override
    public Message getOut(boolean lazyCreate) {
        if (this.out == null && lazyCreate) {
            this.out = this.createOutMessage();
            this.configureMessage(this.out);
        }
        return this.out;
    }

    @Override
    public void setOut(Message out) {
        this.out = out;
        this.configureMessage(out);
    }

    @Override
    public Throwable getException() {
        return this.exception;
    }

    @Override
    public void setException(Throwable exception) {
        this.exception = exception;
    }

    @Override
    public ExchangePattern getPattern() {
        return this.pattern;
    }

    @Override
    public void setPattern(ExchangePattern pattern) {
        this.pattern = pattern;
    }

    public void throwException() throws Exception {
        if (this.exception == null) {
            return;
        }
        if (this.exception instanceof RuntimeException) {
            throw (RuntimeException)this.exception;
        }
        if (this.exception instanceof Exception) {
            throw (Exception)this.exception;
        }
        throw ObjectHelper.wrapRuntimeCamelException(this.exception);
    }

    @Override
    public Message getFault() {
        return this.getFault(true);
    }

    @Override
    public Message getFault(boolean lazyCreate) {
        if (this.fault == null && lazyCreate) {
            this.fault = this.createFaultMessage();
            this.configureMessage(this.fault);
        }
        return this.fault;
    }

    public void setFault(Message fault) {
        this.fault = fault;
        this.configureMessage(fault);
    }

    @Override
    public String getExchangeId() {
        if (this.exchangeId == null) {
            this.exchangeId = DEFAULT_ID_GENERATOR.generateId();
        }
        return this.exchangeId;
    }

    @Override
    public void setExchangeId(String id) {
        this.exchangeId = id;
    }

    @Override
    public boolean isFailed() {
        Object faultBody;
        Message faultMessage = this.getFault(false);
        if (faultMessage != null && (faultBody = faultMessage.getBody()) != null) {
            return true;
        }
        return this.getException() != null;
    }

    @Override
    public boolean isTransacted() {
        Boolean transacted = this.getProperty("org.apache.camel.transacted", Boolean.class);
        return transacted != null && transacted != false;
    }

    @Override
    public UnitOfWork getUnitOfWork() {
        return this.unitOfWork;
    }

    @Override
    public void setUnitOfWork(UnitOfWork unitOfWork) {
        this.unitOfWork = unitOfWork;
    }

    protected Message createInMessage() {
        return new DefaultMessage();
    }

    protected Message createOutMessage() {
        return new DefaultMessage();
    }

    protected Message createFaultMessage() {
        return new DefaultMessage();
    }

    protected void configureMessage(Message message) {
        if (message instanceof MessageSupport) {
            MessageSupport messageSupport = (MessageSupport)message;
            messageSupport.setExchange(this);
        }
    }
}

