/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import org.apache.camel.CamelContext;
import org.apache.camel.NoSuchLanguageException;
import org.apache.camel.spi.Language;
import org.apache.camel.spi.LanguageResolver;
import org.apache.camel.util.FactoryFinder;
import org.apache.camel.util.NoFactoryAvailableException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DefaultLanguageResolver
implements LanguageResolver {
    protected static final FactoryFinder LANGUAGE_FACTORY = new FactoryFinder("META-INF/services/org/apache/camel/language/");
    protected static final FactoryFinder LANGUAGE_RESOLVER = new FactoryFinder("META-INF/services/org/apache/camel/language/resolver/");
    private static final transient Log LOG = LogFactory.getLog(DefaultLanguageResolver.class);

    protected Log getLog() {
        return LOG;
    }

    public Language resolveLanguage(String name, CamelContext context) {
        Object bean = null;
        try {
            bean = context.getRegistry().lookup(name);
            if (bean != null && this.getLog().isDebugEnabled()) {
                this.getLog().debug((Object)("Found language: " + name + " in registry: " + bean));
            }
        }
        catch (Exception e) {
            this.getLog().debug((Object)("Ignored error looking up bean: " + name + ". Error: " + e));
        }
        if (bean != null && bean instanceof Language) {
            return (Language)bean;
        }
        Class type = null;
        try {
            type = this.findLanguage(name);
        }
        catch (NoFactoryAvailableException e) {
        }
        catch (Throwable e) {
            throw new IllegalArgumentException("Invalid URI, no Language registered for scheme : " + name, e);
        }
        if (type != null) {
            if (Language.class.isAssignableFrom(type)) {
                return (Language)context.getInjector().newInstance(type);
            }
            throw new IllegalArgumentException("Type is not a Language implementation. Found: " + type.getName());
        }
        return this.noSpecificLanguageFound(name, context);
    }

    protected Language noSpecificLanguageFound(String name, CamelContext context) {
        Class type = null;
        try {
            type = this.findLanguageResolver("default");
        }
        catch (NoFactoryAvailableException e) {
        }
        catch (Throwable e) {
            throw new IllegalArgumentException("Invalid URI, no Language registered for scheme : " + name, e);
        }
        if (type != null) {
            if (LanguageResolver.class.isAssignableFrom(type)) {
                LanguageResolver resolver = (LanguageResolver)context.getInjector().newInstance(type);
                return resolver.resolveLanguage(name, context);
            }
            throw new IllegalArgumentException("Type is not a LanguageResolver implementation. Found: " + type.getName());
        }
        throw new NoSuchLanguageException(name);
    }

    protected Class findLanguage(String name) throws Exception {
        return LANGUAGE_FACTORY.findClass(name);
    }

    protected Class findLanguageResolver(String name) throws Exception {
        return LANGUAGE_RESOLVER.findClass("default");
    }
}

