/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import java.util.Map;
import org.apache.camel.AsyncCallback;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.FailedToCreateProducerException;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.impl.ServiceSupport;
import org.apache.camel.impl.converter.AsyncProcessorTypeConverter;
import org.apache.camel.util.LRUCache;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.ServiceHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProducerCache<E extends Exchange>
extends ServiceSupport {
    private static final transient Log LOG = LogFactory.getLog(ProducerCache.class);
    private Map<String, Producer<E>> producers = new LRUCache<String, Producer<E>>(1000);

    public synchronized Producer<E> getProducer(Endpoint<E> endpoint) {
        String key = endpoint.getEndpointUri();
        Producer<E> answer = this.producers.get(key);
        if (answer == null) {
            try {
                answer = endpoint.createProducer();
                answer.start();
            }
            catch (Exception e) {
                throw new FailedToCreateProducerException(endpoint, (Throwable)e);
            }
            this.producers.put(key, answer);
        }
        return answer;
    }

    public void send(Endpoint<E> endpoint, E exchange) {
        try {
            Producer<E> producer = this.getProducer(endpoint);
            producer.process((Exchange)exchange);
        }
        catch (Exception e) {
            throw ObjectHelper.wrapRuntimeCamelException(e);
        }
    }

    public E send(Endpoint<E> endpoint, Processor processor) {
        try {
            Producer<E> producer = this.getProducer(endpoint);
            E exchange = producer.createExchange();
            return this.sendExchange(endpoint, producer, processor, exchange);
        }
        catch (Exception e) {
            throw ObjectHelper.wrapRuntimeCamelException(e);
        }
    }

    public E send(Endpoint<E> endpoint, Processor processor, AsyncCallback callback) {
        try {
            Producer<E> producer = this.getProducer(endpoint);
            E exchange = producer.createExchange();
            boolean sync = this.sendExchange(endpoint, producer, processor, exchange, callback);
            ProducerCache.setProcessedSync(exchange, sync);
            return exchange;
        }
        catch (Exception e) {
            throw ObjectHelper.wrapRuntimeCamelException(e);
        }
    }

    public static boolean isProcessedSync(Exchange exchange) {
        Boolean rc = exchange.getProperty(ProducerCache.class.getName() + ".SYNC", Boolean.class);
        return rc == null ? false : rc;
    }

    public static void setProcessedSync(Exchange exchange, boolean b) {
        exchange.setProperty(ProducerCache.class.getName() + ".SYNC", b ? Boolean.TRUE : Boolean.FALSE);
    }

    public E send(Endpoint<E> endpoint, ExchangePattern pattern, Processor processor) {
        try {
            Producer<ExchangePattern> producer = this.getProducer(endpoint);
            ExchangePattern exchange = producer.createExchange(pattern);
            return (E)((Object)this.sendExchange(endpoint, producer, processor, exchange));
        }
        catch (Exception e) {
            throw ObjectHelper.wrapRuntimeCamelException(e);
        }
    }

    protected E sendExchange(Endpoint<E> endpoint, Producer<E> producer, Processor processor, E exchange) throws Exception {
        processor.process((Exchange)exchange);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)(">>>> " + endpoint + " " + exchange));
        }
        producer.process((Exchange)exchange);
        return exchange;
    }

    protected boolean sendExchange(Endpoint<E> endpoint, Producer<E> producer, Processor processor, E exchange, AsyncCallback callback) throws Exception {
        processor.process((Exchange)exchange);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)(">>>> " + endpoint + " " + exchange));
        }
        return AsyncProcessorTypeConverter.convert(producer).process((Exchange)exchange, callback);
    }

    @Override
    protected void doStop() throws Exception {
        ServiceHelper.stopServices(this.producers.values());
        this.producers.clear();
    }

    @Override
    protected void doStart() throws Exception {
    }
}

