/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.converter;

import java.lang.reflect.Method;
import org.apache.camel.Exchange;
import org.apache.camel.TypeConverter;
import org.apache.camel.util.ObjectHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StaticMethodTypeConverter
implements TypeConverter {
    private final Method method;
    private final boolean useExchange;

    public StaticMethodTypeConverter(Method method) {
        this.method = method;
        this.useExchange = method.getParameterTypes().length == 2;
    }

    public String toString() {
        return "StaticMethodTypeConverter: " + this.method;
    }

    @Override
    public <T> T convertTo(Class<T> type, Object value) {
        return this.convertTo(type, null, value);
    }

    @Override
    public <T> T convertTo(Class<T> type, Exchange exchange, Object value) {
        return (T)(this.useExchange ? ObjectHelper.invokeMethod(this.method, null, value, exchange) : ObjectHelper.invokeMethod(this.method, null, value));
    }
}

