/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.camel.Expression;
import org.apache.camel.Predicate;
import org.apache.camel.Processor;
import org.apache.camel.builder.ExpressionClause;
import org.apache.camel.model.ExpressionNode;
import org.apache.camel.model.ExpressionSubElementType;
import org.apache.camel.model.language.ExpressionType;
import org.apache.camel.processor.Aggregator;
import org.apache.camel.processor.aggregate.AggregationCollection;
import org.apache.camel.processor.aggregate.AggregationStrategy;
import org.apache.camel.processor.aggregate.UseLatestAggregationStrategy;
import org.apache.camel.spi.RouteContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@XmlRootElement(name="aggregator")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class AggregatorType
extends ExpressionNode {
    @XmlTransient
    private AggregationStrategy aggregationStrategy;
    @XmlTransient
    private AggregationCollection aggregationCollection;
    @XmlAttribute(required=false)
    private Integer batchSize;
    @XmlAttribute(required=false)
    private Integer outBatchSize;
    @XmlAttribute(required=false)
    private Long batchTimeout;
    @XmlAttribute(required=false)
    private String strategyRef;
    @XmlAttribute(required=false)
    private String collectionRef;
    @XmlElement(name="completedPredicate", required=false)
    private ExpressionSubElementType completedPredicate;

    public AggregatorType() {
    }

    public AggregatorType(Expression correlationExpression) {
        super(correlationExpression);
    }

    public AggregatorType(ExpressionType correlationExpression) {
        super(correlationExpression);
    }

    public AggregatorType(Expression correlationExpression, AggregationStrategy aggregationStrategy) {
        super(correlationExpression);
        this.aggregationStrategy = aggregationStrategy;
    }

    public String toString() {
        return "Aggregator[" + this.getExpression() + " -> " + this.getOutputs() + "]";
    }

    @Override
    public String getShortName() {
        return "aggregator";
    }

    @Override
    public Processor createProcessor(RouteContext routeContext) throws Exception {
        return this.createAggregator(routeContext);
    }

    protected Aggregator createAggregator(RouteContext routeContext) throws Exception {
        Aggregator aggregator;
        Processor processor = routeContext.createProcessor(this);
        if (this.getAggregationCollection() == null) {
            this.setAggregationCollection(this.createAggregationCollection(routeContext));
        }
        if (this.aggregationCollection != null) {
            if (this.aggregationCollection.getCorrelationExpression() == null) {
                this.aggregationCollection.setCorrelationExpression(this.getExpression());
            }
            if (this.aggregationCollection.getAggregationStrategy() == null) {
                AggregationStrategy strategy = this.createAggregationStrategy(routeContext);
                this.aggregationCollection.setAggregationStrategy(strategy);
            }
            aggregator = new Aggregator(processor, this.aggregationCollection);
        } else {
            AggregationStrategy strategy = this.createAggregationStrategy(routeContext);
            Expression aggregateExpression = this.getExpression().createExpression(routeContext);
            Predicate predicate = null;
            if (this.getCompletedPredicate() != null) {
                predicate = this.getCompletedPredicate().createPredicate(routeContext);
            }
            aggregator = predicate != null ? new Aggregator(processor, aggregateExpression, strategy, predicate) : new Aggregator(processor, aggregateExpression, strategy);
        }
        if (this.batchSize != null) {
            aggregator.setBatchSize(this.batchSize);
        }
        if (this.batchTimeout != null) {
            aggregator.setBatchTimeout(this.batchTimeout);
        }
        if (this.outBatchSize != null) {
            aggregator.setOutBatchSize(this.outBatchSize);
        }
        return aggregator;
    }

    private AggregationStrategy createAggregationStrategy(RouteContext routeContext) {
        AggregationStrategy strategy = this.getAggregationStrategy();
        if (strategy == null && this.strategyRef != null) {
            strategy = routeContext.lookup(this.strategyRef, AggregationStrategy.class);
        }
        if (strategy == null) {
            strategy = new UseLatestAggregationStrategy();
        }
        return strategy;
    }

    private AggregationCollection createAggregationCollection(RouteContext routeContext) {
        AggregationCollection collection = this.getAggregationCollection();
        if (collection == null && this.collectionRef != null) {
            collection = routeContext.lookup(this.collectionRef, AggregationCollection.class);
        }
        return collection;
    }

    public AggregationCollection getAggregationCollection() {
        return this.aggregationCollection;
    }

    public void setAggregationCollection(AggregationCollection aggregationCollection) {
        this.aggregationCollection = aggregationCollection;
    }

    public AggregationStrategy getAggregationStrategy() {
        return this.aggregationStrategy;
    }

    public void setAggregationStrategy(AggregationStrategy aggregationStrategy) {
        this.aggregationStrategy = aggregationStrategy;
    }

    public Integer getBatchSize() {
        return this.batchSize;
    }

    public void setBatchSize(Integer batchSize) {
        this.batchSize = batchSize;
    }

    public Integer getOutBatchSize() {
        return this.outBatchSize;
    }

    public void setOutBatchSize(Integer outBatchSize) {
        this.outBatchSize = outBatchSize;
    }

    public Long getBatchTimeout() {
        return this.batchTimeout;
    }

    public void setBatchTimeout(Long batchTimeout) {
        this.batchTimeout = batchTimeout;
    }

    public String getStrategyRef() {
        return this.strategyRef;
    }

    public void setStrategyRef(String strategyRef) {
        this.strategyRef = strategyRef;
    }

    public void setCompletedPredicate(ExpressionSubElementType completedPredicate) {
        this.completedPredicate = completedPredicate;
    }

    public ExpressionSubElementType getCompletedPredicate() {
        return this.completedPredicate;
    }

    public AggregatorType batchSize(int batchSize) {
        this.setBatchSize(batchSize);
        return this;
    }

    public AggregatorType outBatchSize(int batchSize) {
        this.setOutBatchSize(batchSize);
        return this;
    }

    public AggregatorType batchTimeout(long batchTimeout) {
        this.setBatchTimeout(batchTimeout);
        return this;
    }

    public AggregatorType aggregationCollection(AggregationCollection aggregationCollection) {
        this.setAggregationCollection(aggregationCollection);
        return this;
    }

    public AggregatorType aggregationStrategy(AggregationStrategy aggregationStrategy) {
        this.setAggregationStrategy(aggregationStrategy);
        return this;
    }

    public AggregatorType strategyRef(String strategyRef) {
        this.setStrategyRef(strategyRef);
        return this;
    }

    public ExpressionClause<AggregatorType> completedPredicate() {
        this.checkNoCompletedPredicate();
        ExpressionClause<AggregatorType> clause = new ExpressionClause<AggregatorType>(this);
        this.setCompletedPredicate(new ExpressionSubElementType(clause));
        return clause;
    }

    public AggregatorType completedPredicate(Predicate predicate) {
        this.checkNoCompletedPredicate();
        this.setCompletedPredicate(new ExpressionSubElementType(predicate));
        return this;
    }

    protected void checkNoCompletedPredicate() {
        if (this.getCompletedPredicate() != null) {
            throw new IllegalArgumentException("There is already a completedPredicate defined for this aggregator: " + this);
        }
    }
}

