/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.view;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.camel.CamelContext;
import org.apache.camel.model.ChoiceType;
import org.apache.camel.model.FromType;
import org.apache.camel.model.MulticastType;
import org.apache.camel.model.ProcessorType;
import org.apache.camel.model.RouteType;
import org.apache.camel.model.ToType;
import org.apache.camel.model.language.ExpressionType;
import org.apache.camel.util.CollectionStringBuffer;
import org.apache.camel.view.NodeData;
import org.apache.camel.view.RouteDotGenerator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class GraphGeneratorSupport {
    private static final transient Log LOG = LogFactory.getLog(RouteDotGenerator.class);
    protected String dir;
    protected int clusterCounter;
    protected String extension;
    private String imagePrefix = "http://activemq.apache.org/camel/images/eip/";
    private Map<Object, NodeData> nodeMap = new HashMap<Object, NodeData>();
    private boolean makeParentDirs = true;
    private Map<String, List<RouteType>> routeGroupMap;

    protected GraphGeneratorSupport(String dir, String extension) {
        this.dir = dir;
        this.extension = extension;
    }

    public String getDir() {
        return this.dir;
    }

    public void setDir(String dir) {
        this.dir = dir;
    }

    public void drawRoutes(CamelContext context) throws IOException {
        File parent = new File(this.dir);
        if (this.makeParentDirs) {
            parent.mkdirs();
        }
        List<RouteType> routes = context.getRouteDefinitions();
        this.routeGroupMap = this.createRouteGroupMap(routes);
        this.generateFile(parent, "routes" + this.extension, this.routeGroupMap);
        if (this.routeGroupMap.size() >= 1) {
            Set<Map.Entry<String, List<RouteType>>> entries = this.routeGroupMap.entrySet();
            for (Map.Entry<String, List<RouteType>> entry : entries) {
                HashMap<String, List<RouteType>> map = new HashMap<String, List<RouteType>>();
                String group = entry.getKey();
                map.put(group, entry.getValue());
                this.generateFile(parent, group + this.extension, map);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateFile(File parent, String fileName, Map<String, List<RouteType>> map) throws IOException {
        this.nodeMap.clear();
        this.clusterCounter = 0;
        PrintWriter writer = new PrintWriter(new FileWriter(new File(parent, fileName)));
        try {
            this.generateFile(writer, map);
        }
        finally {
            writer.close();
        }
    }

    protected abstract void generateFile(PrintWriter var1, Map<String, List<RouteType>> var2);

    protected boolean isMulticastNode(ProcessorType node) {
        return node instanceof MulticastType || node instanceof ChoiceType;
    }

    protected String getLabel(List<ExpressionType> expressions) {
        CollectionStringBuffer buffer = new CollectionStringBuffer();
        for (ExpressionType expression : expressions) {
            buffer.append(this.getLabel(expression));
        }
        return buffer.toString();
    }

    protected String getLabel(ExpressionType expression) {
        if (expression != null) {
            return expression.getLabel();
        }
        return "";
    }

    protected NodeData getNodeData(Object node) {
        Object key = node;
        if (node instanceof FromType) {
            FromType fromType = (FromType)node;
            key = fromType.getUriOrRef();
        } else if (node instanceof ToType) {
            ToType toType = (ToType)node;
            key = toType.getUriOrRef();
        }
        NodeData answer = this.nodeMap.get(key);
        if (answer == null) {
            String id = "node" + (this.nodeMap.size() + 1);
            answer = new NodeData(id, node, this.imagePrefix);
            this.nodeMap.put(key, answer);
        }
        return answer;
    }

    protected Map<String, List<RouteType>> createRouteGroupMap(List<RouteType> routes) {
        HashMap<String, List<RouteType>> map = new HashMap<String, List<RouteType>>();
        for (RouteType route : routes) {
            ArrayList<RouteType> list;
            String group = route.getGroup();
            if (group == null) {
                group = "Camel Routes";
            }
            if ((list = (ArrayList<RouteType>)map.get(group)) == null) {
                list = new ArrayList<RouteType>();
                map.put(group, list);
            }
            list.add(route);
        }
        return map;
    }
}

